/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class JARClassLoader
extends ClassLoader {
    private static final Object NO_CLASS = new Object();
    private static int INDEX;
    private static int live;
    private static Map<String, Object> classHash;
    private static Map<String, Object> resourcesHash;
    private int id;
    private boolean delegateFirst;
    private PluginJAR jar;

    public JARClassLoader() {
        this(true);
    }

    public JARClassLoader(boolean bl) {
        this.delegateFirst = bl;
        this.id = INDEX++;
        ++live;
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Object object;
        ClassNotFoundException classNotFoundException = null;
        if (this.delegateFirst) {
            try {
                return this.loadFromParent(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                classNotFoundException = classNotFoundException2;
            }
        }
        if ((object = classHash.get(string)) == NO_CLASS) {
            throw new ClassNotFoundException(string);
        }
        if (object instanceof JARClassLoader) {
            JARClassLoader jARClassLoader = (JARClassLoader)object;
            try {
                return jARClassLoader._loadClass(string, bl);
            }
            catch (ClassNotFoundException classNotFoundException3) {
                classHash.put(string, NO_CLASS);
                throw classNotFoundException3;
            }
        }
        if (this.delegateFirst) {
            throw classNotFoundException;
        }
        return this.loadFromParent(string);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        try {
            Object object;
            Object object2;
            if (this.jar != null && (object2 = ((ZipFile)(object = this.jar.getZipFile())).getEntry(string)) != null) {
                return ((ZipFile)object).getInputStream((ZipEntry)object2);
            }
            object = resourcesHash.get(string);
            if (object instanceof JARClassLoader) {
                object2 = (JARClassLoader)object;
                return ((JARClassLoader)object2).getResourceAsStream(string);
            }
            return JARClassLoader.getSystemResourceAsStream(string);
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException);
            return null;
        }
    }

    @Override
    public URL getResource(String string) {
        try {
            Object object;
            Object object2;
            if (this.jar != null && (object2 = ((ZipFile)(object = this.jar.getZipFile())).getEntry(string)) != null) {
                return new URL(this.getResourceAsPath(string));
            }
            object = resourcesHash.get(string);
            if (object instanceof JARClassLoader) {
                object2 = (JARClassLoader)object;
                return ((JARClassLoader)object2).getResource(string);
            }
            object2 = JARClassLoader.getSystemResource(string);
            if (object2 != null) {
                Log.log(1, JARClassLoader.class, "Would have returned null for getResource(" + string + ")");
                Log.log(1, JARClassLoader.class, "returning(" + object2 + ")");
            }
            return object2;
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException);
            return null;
        }
    }

    public String getResourceAsPath(String string) {
        if (this.jar == null) {
            throw new UnsupportedOperationException("don't call getResourceAsPath() on anonymous JARClassLoader");
        }
        if (!string.startsWith("/")) {
            string = '/' + string;
        }
        return "jeditresource:/" + MiscUtilities.getFileName(this.jar.getPath()) + '!' + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump() {
        Log.log(1, JARClassLoader.class, "Total instances created: " + INDEX);
        Log.log(1, JARClassLoader.class, "Live instances: " + live);
        Map<String, Object> map = classHash;
        synchronized (map) {
            for (Map.Entry<String, Object> entry : classHash.entrySet()) {
                if (entry.getValue() == NO_CLASS) continue;
                Log.log(1, JARClassLoader.class, entry.getKey() + " ==> " + entry.getValue());
            }
        }
    }

    public String toString() {
        if (this.jar == null) {
            return "<anonymous>(" + this.id + ')';
        }
        return this.jar.getPath() + " (" + this.id + ')';
    }

    public Enumeration getResources(String string) throws IOException {
        URL uRL = this.getResource(string);
        class SingleElementEnumeration
        implements Enumeration {
            private Object element;

            SingleElementEnumeration(Object object) {
                this.element = object;
            }

            @Override
            public boolean hasMoreElements() {
                return this.element != null;
            }

            public Object nextElement() {
                if (this.element != null) {
                    Object object = this.element;
                    this.element = null;
                    return object;
                }
                throw new NoSuchElementException();
            }
        }
        return new SingleElementEnumeration(uRL);
    }

    protected void finalize() {
        --live;
    }

    JARClassLoader(PluginJAR pluginJAR) {
        this();
        this.jar = pluginJAR;
    }

    void activate() {
        String[] stringArray;
        Object object;
        if (this.jar.getPlugin() != null) {
            object = jEdit.getProperty("plugin." + this.jar.getPlugin().getClassName() + ".class_loader_delegate");
            boolean bl = this.delegateFirst = object == null || "true".equals(object);
        }
        if ((object = this.jar.getClasses()) != null) {
            for (int i = 0; i < ((String[])object).length; ++i) {
                classHash.put(object[i], this);
            }
        }
        if ((stringArray = this.jar.getResources()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                resourcesHash.put(stringArray[i], this);
            }
        }
    }

    void deactivate() {
        String[] stringArray;
        String[] stringArray2 = this.jar.getClasses();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                Object object = classHash.get(stringArray2[i]);
                if (object != this) continue;
                classHash.remove(stringArray2[i]);
            }
        }
        if ((stringArray = this.jar.getResources()) == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = resourcesHash.get(stringArray[i]);
            if (object != this) continue;
            resourcesHash.remove(stringArray[i]);
        }
    }

    private synchronized Class _loadClass(String string, boolean bl) throws ClassNotFoundException {
        this.jar.activatePlugin();
        JARClassLoader jARClassLoader = this;
        synchronized (jARClassLoader) {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz != null) {
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            String string2 = MiscUtilities.classToFile(string);
            try {
                this.definePackage(string);
                ZipFile zipFile = this.jar.getZipFile();
                ZipEntry zipEntry = zipFile.getEntry(string2);
                if (zipEntry == null) {
                    throw new ClassNotFoundException(string);
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                int n = (int)zipEntry.getSize();
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n2 < n) {
                    if ((n2 = inputStream.read(byArray, n3 += n2, n -= n2)) != -1) continue;
                    Log.log(9, this, "Failed to load class " + string + " from " + zipFile.getName());
                    throw new ClassNotFoundException(string);
                }
                clazz = this.defineClass(string, byArray, 0, byArray.length);
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
                throw new ClassNotFoundException(string);
            }
        }
    }

    private void definePackage(String string) throws IOException {
        String string2;
        int n = string.lastIndexOf(46);
        if (n != -1 && this.getPackage(string2 = string.substring(0, n)) == null) {
            this.definePackage(string2, new JarFile(this.jar.getFile()).getManifest());
        }
    }

    private static String getMfValue(Attributes attributes, Attributes attributes2, Attributes.Name name) {
        String string = null;
        if (attributes != null) {
            string = attributes.getValue(name);
        } else if (attributes2 != null) {
            string = attributes2.getValue(name);
        }
        return string;
    }

    private void definePackage(String string, Manifest manifest) {
        if (manifest == null) {
            this.definePackage(string, null, null, null, null, null, null, null);
            return;
        }
        Attributes attributes = manifest.getAttributes(string.replace('.', '/') + '/');
        Attributes attributes2 = manifest.getMainAttributes();
        URL uRL = null;
        if (Boolean.valueOf(JARClassLoader.getMfValue(attributes, attributes2, Attributes.Name.SEALED)).booleanValue()) {
            try {
                uRL = this.jar.getFile().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.definePackage(string, JARClassLoader.getMfValue(attributes, attributes2, Attributes.Name.SPECIFICATION_TITLE), JARClassLoader.getMfValue(attributes, attributes2, Attributes.Name.SPECIFICATION_VERSION), JARClassLoader.getMfValue(attributes, attributes2, Attributes.Name.SPECIFICATION_VENDOR), JARClassLoader.getMfValue(attributes, attributes2, Attributes.Name.IMPLEMENTATION_TITLE), JARClassLoader.getMfValue(attributes, attributes2, Attributes.Name.IMPLEMENTATION_VERSION), JARClassLoader.getMfValue(attributes, attributes2, Attributes.Name.IMPLEMENTATION_VENDOR), uRL);
    }

    private Class loadFromParent(String string) throws ClassNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : this.findSystemClass(string);
        return clazz;
    }

    static {
        classHash = new Hashtable<String, Object>();
        resourcesHash = new HashMap<String, Object>();
    }
}

