/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import org.gjt.sp.jedit.JEditAbstractEditAction;
import org.gjt.sp.jedit.JEditActionSet;
import org.gjt.sp.util.StandardUtilities;

public abstract class JEditActionContext<F extends JEditAbstractEditAction, E extends JEditActionSet<F>> {
    String[] actionNames;
    Hashtable<String, E> actionHash = new Hashtable();
    Hashtable<String, E> overriddenActions = new Hashtable();
    private final Vector<E> actionSets = new Vector();

    public abstract void invokeAction(EventObject var1, F var2);

    public void addActionSet(E e) {
        this.actionNames = null;
        this.actionSets.addElement(e);
        ((JEditActionSet)e).context = this;
        String[] stringArray = ((JEditActionSet)e).getActionNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.actionHash.containsKey(stringArray[i])) {
                JEditActionSet jEditActionSet = (JEditActionSet)this.actionHash.get(stringArray[i]);
                this.overriddenActions.put(stringArray[i], jEditActionSet);
            }
            this.actionHash.put(stringArray[i], e);
        }
    }

    public void removeActionSet(E e) {
        this.actionNames = null;
        this.actionSets.removeElement(e);
        ((JEditActionSet)e).context = null;
        String[] stringArray = ((JEditActionSet)e).getActionNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.actionHash.remove(stringArray[i]);
            if (!this.overriddenActions.containsKey(stringArray[i])) continue;
            JEditActionSet jEditActionSet = (JEditActionSet)this.overriddenActions.remove(stringArray[i]);
            this.actionHash.put(stringArray[i], jEditActionSet);
        }
    }

    public E[] getActionSets() {
        if (this.actionSets.isEmpty()) {
            return null;
        }
        Class<?> clazz = ((JEditActionSet)this.actionSets.get(0)).getClass();
        Object[] objectArray = (JEditActionSet[])Array.newInstance(clazz, this.actionSets.size());
        this.actionSets.copyInto(objectArray);
        return objectArray;
    }

    public F getAction(String string) {
        JEditActionSet jEditActionSet = (JEditActionSet)this.actionHash.get(string);
        if (jEditActionSet == null) {
            return null;
        }
        return (F)jEditActionSet.getAction(string);
    }

    public E getActionSetForAction(String string) {
        return (E)((JEditActionSet)this.actionHash.get(string));
    }

    public String[] getActionNames() {
        if (this.actionNames == null) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int i = 0; i < this.actionSets.size(); ++i) {
                ((JEditActionSet)this.actionSets.elementAt(i)).getActionNames(linkedList);
            }
            this.actionNames = linkedList.toArray(new String[linkedList.size()]);
            Arrays.sort(this.actionNames, new StandardUtilities.StringCompare(true));
        }
        return this.actionNames;
    }
}

