/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.BrowserListener;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.browser.VFSFileNameField;
import org.gjt.sp.jedit.bufferio.IoTask;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskListener;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

public class VFSFileChooserDialog
extends EnhancedDialog {
    private VFSBrowser browser;
    private VFSFileNameField filenameField;
    private String filename;
    private JButton ok;
    private JButton cancel;
    private boolean isOK;
    private TaskListener ioTaskHandler;

    public VFSFileChooserDialog(View view, String string, int n, boolean bl) {
        this(view, string, n, bl, true);
    }

    public VFSFileChooserDialog(View view, String string, int n, boolean bl, boolean bl2) {
        super(view, VFSFileChooserDialog.getTitle(n), true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this._init(view, string, n, bl, bl2);
    }

    public VFSFileChooserDialog(Dialog dialog, View view, String string, int n, boolean bl, boolean bl2) {
        super(dialog, VFSFileChooserDialog.getTitle(n), true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this._init(view, string, n, bl, bl2);
    }

    public VFSFileChooserDialog(Frame frame, View view, String string, int n, boolean bl, boolean bl2) {
        super(frame, VFSFileChooserDialog.getTitle(n), true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this._init(view, string, n, bl, bl2);
    }

    public VFSBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public void dispose() {
        GUIUtilities.saveGeometry(this, "vfs.browser.dialog");
        TaskManager.instance.removeTaskListener(this.ioTaskHandler);
        super.dispose();
    }

    @Override
    public void ok() {
        boolean bl;
        VFSFile[] vFSFileArray = this.browser.getSelectedFiles();
        this.filename = this.filenameField.getText();
        boolean bl2 = bl = this.browser.getMode() == 3;
        if (vFSFileArray.length != 0) {
            if (bl) {
                this.isOK = true;
                this.dispose();
            } else {
                this.browser.filesActivated(0, false);
            }
            return;
        }
        if (bl && (this.filename == null || this.filename.length() == 0)) {
            this.isOK = true;
            this.dispose();
            return;
        }
        if (this.filename == null || this.filename.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        String string = this.browser.getView().getBuffer().getDirectory();
        if (this.filename.equals("-")) {
            this.filename = string;
        } else if (this.filename.startsWith("-/") || this.filename.startsWith('-' + File.separator)) {
            this.filename = MiscUtilities.constructPath(string, this.filename.substring(2));
        }
        final int[] nArray = new int[]{-1};
        this.filename = MiscUtilities.expandVariables(this.filename);
        final String string2 = MiscUtilities.constructPath(this.browser.getDirectory(), this.filename);
        final VFS vFS = VFSManager.getVFSForPath(string2);
        Object object = vFS.createVFSSession(string2, this);
        if (object == null) {
            return;
        }
        ThreadUtilities.runInBackground(new GetFileTypeRequest(vFS, object, string2, nArray));
        AwtRunnableQueue.INSTANCE.runAfterIoTasks(new Runnable(){

            @Override
            public void run() {
                switch (nArray[0]) {
                    case 0: {
                        if (VFSFileChooserDialog.this.browser.getMode() == 3 || vFS instanceof FileVFS && VFSFileChooserDialog.this.doFileExistsWarning(string2)) break;
                        VFSFileChooserDialog.this.isOK = true;
                        if (VFSFileChooserDialog.this.browser.getMode() == 4) {
                            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                            if (((VFSFileChooserDialog)VFSFileChooserDialog.this).browser.currentEncoding != null) {
                                hashtable.put("encoding", ((VFSFileChooserDialog)VFSFileChooserDialog.this).browser.currentEncoding);
                            }
                            jEdit.openFile(VFSFileChooserDialog.this.browser.getView(), VFSFileChooserDialog.this.browser.getDirectory(), string2, false, hashtable);
                        }
                        VFSFileChooserDialog.this.dispose();
                        break;
                    }
                    case 1: 
                    case 2: {
                        VFSFileChooserDialog.this.browser.setDirectory(string2);
                    }
                }
            }
        });
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public String[] getSelectedFiles() {
        if (!this.isOK) {
            return null;
        }
        if (this.browser.getMode() == 3) {
            if (this.browser.getSelectedFiles().length > 0) {
                return this.getSelectedFiles(1, 2);
            }
            return new String[]{this.browser.getDirectory()};
        }
        if (this.filename != null && this.filename.length() != 0) {
            String string = this.browser.getDirectory();
            return new String[]{MiscUtilities.constructPath(string, this.filename)};
        }
        return this.getSelectedFiles(0, 0);
    }

    private static String getDefaultTitle() {
        return jEdit.getProperty("vfs.browser.title");
    }

    private static String getTitle(int n) {
        switch (n) {
            case 0: {
                return jEdit.getProperty("vfs.browser.title.open");
            }
            case 1: {
                return jEdit.getProperty("vfs.browser.title.save");
            }
            case 2: {
                return jEdit.getProperty("vfs.browser.title");
            }
            case 3: {
                return jEdit.getProperty("vfs.browser.title");
            }
            case 4: {
                return jEdit.getProperty("vfs.browser.title.dialog");
            }
        }
        return jEdit.getProperty("vfs.browser.title");
    }

    private void _init(View view, String string, int n, boolean bl, boolean bl2) {
        Object object;
        String string2;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        if (n == 3) {
            string2 = null;
        } else if (string == null || string.endsWith(File.separator) || string.endsWith("/")) {
            string2 = null;
        } else {
            object = VFSManager.getVFSForPath(string);
            string2 = ((VFS)object).getFileName(string);
            string = ((VFS)object).getParentOfPath(string);
            if ((((VFS)object).getCapabilities() & 4) == 0) {
                string = null;
            }
        }
        this.browser = new VFSBrowser(view, string, n, bl, null);
        this.browser.addBrowserListener(new BrowserHandler());
        jPanel.add("Center", this.browser);
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 0));
        ((JComponent)object).setBorder(new EmptyBorder(12, 12, 12, 12));
        this.filenameField = new VFSFileNameField(this.browser, null);
        this.filenameField.setText(string2);
        this.filenameField.selectAll();
        this.filenameField.setName("filename");
        this.browser.setDefaultFocusComponent(this.filenameField);
        Box box = new Box(1);
        box.add(Box.createGlue());
        box.add(this.filenameField);
        box.add(Box.createGlue());
        JLabel jLabel = new JLabel(jEdit.getProperty("vfs.browser.dialog.filename"));
        jLabel.setDisplayedMnemonic(jEdit.getProperty("vfs.browser.dialog.filename.mnemonic").charAt(0));
        jLabel.setLabelFor(this.filenameField);
        ((Container)object).add(jLabel);
        ((Container)object).add(Box.createHorizontalStrut(12));
        ((Container)object).add(box);
        ((Container)object).add(Box.createHorizontalStrut(12));
        this.ok = new JButton();
        this.ok.setName("ok");
        this.getRootPane().setDefaultButton(this.ok);
        switch (n) {
            case 0: 
            case 4: {
                this.ok.setText(jEdit.getProperty("vfs.browser.dialog.open"));
                break;
            }
            case 3: {
                this.ok.setText(jEdit.getProperty("vfs.browser.dialog.choose-dir"));
                Dimension dimension = this.ok.getPreferredSize();
                this.ok.setPreferredSize(dimension);
                break;
            }
            case 1: {
                this.ok.setText(jEdit.getProperty("vfs.browser.dialog.save"));
            }
        }
        this.ok.addActionListener(new ActionHandler());
        ((Container)object).add(this.ok);
        ((Container)object).add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.setName("cancel");
        this.cancel.addActionListener(new ActionHandler());
        ((Container)object).add(this.cancel);
        jPanel.add("South", (Component)object);
        this.ioTaskHandler = new IoTaskHandler();
        TaskManager.instance.addTaskListener(this.ioTaskHandler);
        this.pack();
        GUIUtilities.loadGeometry(this, "vfs.browser.dialog");
        GUIUtilities.requestFocus(this, this.filenameField);
        if (bl2) {
            this.setVisible(true);
        }
    }

    private boolean doFileExistsWarning(String string) {
        Object[] objectArray;
        int n;
        return this.browser.getMode() == 1 && new File(string).exists() && (n = GUIUtilities.confirm(this.browser, "fileexists", objectArray = new String[]{MiscUtilities.getFileName(string)}, 0, 2)) != 0;
    }

    private String[] getSelectedFiles(int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        VFSFile[] vFSFileArray = this.browser.getSelectedFiles();
        for (int i = 0; i < vFSFileArray.length; ++i) {
            VFSFile vFSFile = vFSFileArray[i];
            if (vFSFile.getType() != n && vFSFile.getType() != n2) continue;
            arrayList.add(vFSFile.getPath());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private class GetFileTypeRequest
    extends IoTask {
        VFS vfs;
        Object session;
        String path;
        int[] type;

        GetFileTypeRequest(VFS vFS, Object object, String string, int[] nArray) {
            this.vfs = vFS;
            this.session = object;
            this.path = string;
            this.type = nArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void _run() {
            try {
                VFSFile vFSFile = this.vfs._getFile(this.session, this.path, VFSFileChooserDialog.this.browser);
                this.type[0] = vFSFile == null ? 0 : vFSFile.getType();
            }
            catch (IOException iOException) {
                VFSManager.error(iOException, this.path, VFSFileChooserDialog.this.browser);
            }
            finally {
                try {
                    this.vfs._endVFSSession(this.session, VFSFileChooserDialog.this.browser);
                }
                catch (IOException iOException) {
                    VFSManager.error(iOException, this.path, VFSFileChooserDialog.this.browser);
                }
            }
        }
    }

    private class IoTaskHandler
    implements TaskListener {
        private final Runnable cursorStatus = new Runnable(){

            @Override
            public void run() {
                int n = TaskManager.instance.countIoTasks();
                if (n == 0) {
                    VFSFileChooserDialog.this.getContentPane().setCursor(Cursor.getDefaultCursor());
                } else if (n >= 1) {
                    VFSFileChooserDialog.this.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        };

        private IoTaskHandler() {
        }

        @Override
        public void waiting(Task task) {
            SwingUtilities.invokeLater(this.cursorStatus);
        }

        @Override
        public void running(Task task) {
            SwingUtilities.invokeLater(this.cursorStatus);
        }

        @Override
        public void done(Task task) {
            SwingUtilities.invokeLater(this.cursorStatus);
        }

        @Override
        public void statusUpdated(Task task) {
        }

        @Override
        public void maximumUpdated(Task task) {
        }

        @Override
        public void valueUpdated(Task task) {
            SwingUtilities.invokeLater(this.cursorStatus);
        }
    }

    private class BrowserHandler
    implements BrowserListener {
        private BrowserHandler() {
        }

        @Override
        public void filesSelected(VFSBrowser vFSBrowser, VFSFile[] vFSFileArray) {
            boolean bl;
            boolean bl2 = bl = vFSBrowser.getMode() == 3;
            if (vFSFileArray.length == 0) {
                if (bl) {
                    VFSFileChooserDialog.this.ok.setText(jEdit.getProperty("vfs.browser.dialog.choose-dir"));
                }
            } else if (vFSFileArray.length == 1) {
                VFSFile vFSFile;
                if (bl) {
                    VFSFileChooserDialog.this.ok.setText(jEdit.getProperty("vfs.browser.dialog.choose-dir"));
                }
                if ((vFSFile = vFSFileArray[0]).getType() == 0) {
                    String string = vFSFile.getPath();
                    String string2 = vFSBrowser.getDirectory();
                    String string3 = MiscUtilities.getParentOfPath(string);
                    if (MiscUtilities.pathsEqual(string3, string2)) {
                        string = vFSFile.getName();
                    }
                    VFSFileChooserDialog.this.filenameField.setText(string);
                    VFSFileChooserDialog.this.filenameField.selectAll();
                }
            } else {
                if (bl) {
                    VFSFileChooserDialog.this.ok.setText(jEdit.getProperty("vfs.browser.dialog.choose-dir"));
                }
                VFSFileChooserDialog.this.filenameField.setText(null);
            }
        }

        @Override
        public void filesActivated(VFSBrowser vFSBrowser, VFSFile[] vFSFileArray) {
            VFSFileChooserDialog.this.filenameField.selectAll();
            if (vFSFileArray.length == 0) {
                VFSFileChooserDialog.this.ok();
                return;
            }
            int n = 0;
            int n2 = vFSFileArray.length;
            if (n < n2) {
                if (vFSFileArray[n].getType() == 0) {
                    String string = vFSFileArray[n].getPath();
                    VFS vFS = VFSManager.getVFSForPath(string);
                    if (vFSBrowser.getMode() == 1 && vFS instanceof FileVFS && VFSFileChooserDialog.this.doFileExistsWarning(string)) {
                        return;
                    }
                    VFSFileChooserDialog.this.isOK = true;
                    VFSFileChooserDialog.this.filenameField.setText(null);
                    if (vFSBrowser.getMode() != 3) {
                        VFSFileChooserDialog.this.dispose();
                    }
                    return;
                }
                return;
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == VFSFileChooserDialog.this.ok) {
                VFSFileChooserDialog.this.ok();
            } else if (actionEvent.getSource() == VFSFileChooserDialog.this.cancel) {
                VFSFileChooserDialog.this.cancel();
            }
        }
    }
}

