/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.gui.JCheckBoxList;

class CheckBoxListModel
extends AbstractTableModel {
    Vector<JCheckBoxList.Entry> items;

    CheckBoxListModel(Vector vector) {
        this.items = new Vector(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            this.items.add(CheckBoxListModel.createEntry(vector.elementAt(i)));
        }
    }

    CheckBoxListModel(Object[] objectArray) {
        this.items = new Vector(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            this.items.add(CheckBoxListModel.createEntry(objectArray[i]));
        }
    }

    private static JCheckBoxList.Entry createEntry(Object object) {
        if (object instanceof JCheckBoxList.Entry) {
            return (JCheckBoxList.Entry)object;
        }
        return new JCheckBoxList.Entry(false, object);
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        return null;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        JCheckBoxList.Entry entry = this.items.get(n);
        switch (n2) {
            case 0: {
                return entry.checked;
            }
            case 1: {
                return entry.value;
            }
        }
        throw new InternalError();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        throw new InternalError();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        JCheckBoxList.Entry entry = this.items.get(n);
        return n2 == 0 && !entry.caption;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            JCheckBoxList.Entry entry = this.items.get(n);
            if (!entry.caption) {
                entry.checked = object.equals(Boolean.TRUE);
                this.fireTableRowsUpdated(n, n);
            }
        }
    }
}

