/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.AbstractContextOptionPane;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class ContextAddDialog
extends EnhancedDialog {
    private static final String CONTEXT_ADD_DIALOG_LAST_SELECTION = "contextAddDialog.lastSelection";
    private boolean isOK;
    private final JRadioButton separator;
    private final JRadioButton action;
    private final JComboBox combo;
    private final JList list;
    private final JButton ok;
    private final JButton cancel;

    public ContextAddDialog(Component component, ActionContext actionContext) {
        super(GUIUtilities.getParentDialog(component), jEdit.getProperty("options.context.add.title"), true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        ActionHandler actionHandler = new ActionHandler();
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 6, 6));
        jPanel2.setBorder(new EmptyBorder(0, 0, 6, 0));
        jPanel2.add(new JLabel(jEdit.getProperty("options.context.add.caption")));
        this.separator = new JRadioButton(jEdit.getProperty("options.context.add.separator"));
        this.separator.addActionListener(actionHandler);
        buttonGroup.add(this.separator);
        jPanel2.add(this.separator);
        this.action = new JRadioButton(jEdit.getProperty("options.context.add.action"));
        this.action.addActionListener(actionHandler);
        buttonGroup.add(this.action);
        this.action.setSelected(true);
        jPanel2.add(this.action);
        jPanel.add("North", jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout(6, 6));
        ActionSet[] actionSetArray = (ActionSet[])actionContext.getActionSets();
        TreeSet<ActionSet> treeSet = new TreeSet<ActionSet>();
        String string = jEdit.getProperty(CONTEXT_ADD_DIALOG_LAST_SELECTION);
        for (ActionSet actionSet : actionSetArray) {
            if (actionSet.getActionCount() == 0) continue;
            treeSet.add(actionSet);
        }
        int n = 0;
        int n2 = 0;
        for (ActionSet actionSet : treeSet) {
            if (actionSet.getLabel().equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        this.combo = new JComboBox<Object>(treeSet.toArray());
        this.combo.setSelectedIndex(n);
        this.combo.addActionListener(actionHandler);
        jPanel3.add("North", this.combo);
        this.list = new JList();
        this.list.setVisibleRowCount(8);
        this.list.setSelectionMode(0);
        jPanel3.add("Center", new JScrollPane(this.list));
        jPanel.add("Center", jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setBorder(new EmptyBorder(12, 0, 0, 0));
        jPanel4.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(actionHandler);
        this.getRootPane().setDefaultButton(this.ok);
        jPanel4.add(this.ok);
        jPanel4.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(actionHandler);
        jPanel4.add(this.cancel);
        jPanel4.add(Box.createGlue());
        jPanel.add("South", jPanel4);
        this.updateList();
        this.pack();
        this.setLocationRelativeTo(GUIUtilities.getParentDialog(component));
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.isOK = true;
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public String getSelection() {
        if (!this.isOK) {
            return null;
        }
        if (this.separator.isSelected()) {
            return "-";
        }
        if (this.action.isSelected()) {
            AbstractContextOptionPane.MenuItem menuItem = (AbstractContextOptionPane.MenuItem)this.list.getSelectedValue();
            return menuItem == null ? null : menuItem.actionName;
        }
        throw new InternalError();
    }

    private void updateList() {
        ActionSet actionSet = (ActionSet)this.combo.getSelectedItem();
        jEdit.setProperty(CONTEXT_ADD_DIALOG_LAST_SELECTION, actionSet.getLabel());
        EditAction[] editActionArray = actionSet.getActions();
        Vector<AbstractContextOptionPane.MenuItem> vector = new Vector<AbstractContextOptionPane.MenuItem>(editActionArray.length);
        for (int i = 0; i < editActionArray.length; ++i) {
            EditAction editAction = editActionArray[i];
            String string = editAction.getLabel();
            if (string == null) continue;
            vector.addElement(new AbstractContextOptionPane.MenuItem(editAction.getName(), string));
        }
        Collections.sort(vector, new AbstractContextOptionPane.MenuItemCompare());
        this.list.setListData(vector);
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JRadioButton) {
                ContextAddDialog.this.combo.setEnabled(ContextAddDialog.this.action.isSelected());
                ContextAddDialog.this.list.setEnabled(ContextAddDialog.this.action.isSelected());
            }
            if (object == ContextAddDialog.this.ok) {
                ContextAddDialog.this.ok();
            } else if (object == ContextAddDialog.this.cancel) {
                ContextAddDialog.this.cancel();
            } else if (object == ContextAddDialog.this.combo) {
                ContextAddDialog.this.updateList();
            }
        }
    }
}

