/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.KeyEvent;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.util.Log;

public class KeyEventWorkaround {
    private static int last;
    private static final int LAST_NOTHING = 0;
    private static final int LAST_NUMKEYPAD = 1;
    private static final int LAST_ALT = 2;

    public static boolean isBindable(int n) {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 157: 
            case 65406: {
                return false;
            }
        }
        return true;
    }

    public static boolean isPrintable(int n) {
        switch (n) {
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 160: 
            case 161: 
            case 162: 
            case 192: 
            case 222: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMacControl(KeyEvent keyEvent) {
        return OperatingSystem.isMacOS() && (keyEvent.getModifiers() & 2) != 0 && keyEvent.getKeyChar() <= '+';
    }

    public static boolean isNumericKeypad(int n) {
        switch (n) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyEvent processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        int n2 = keyEvent.getModifiers();
        block0 : switch (keyEvent.getID()) {
            case 401: {
                switch (n) {
                    case 0: {
                        return null;
                    }
                    case 16: 
                    case 17: 
                    case 18: 
                    case 157: 
                    case 65406: {
                        return keyEvent;
                    }
                }
                if (!keyEvent.isMetaDown() && !keyEvent.isControlDown() && !keyEvent.isAltDown() && KeyEventWorkaround.isPrintable(n)) {
                    return null;
                }
                if (Debug.ALT_KEY_PRESSED_DISABLED && (n2 & 8) != 0) {
                    return null;
                }
                if (KeyEventWorkaround.isNumericKeypad(n)) {
                    last = 1;
                    return keyEvent;
                }
                last = 0;
                return keyEvent;
            }
            case 400: {
                if (!(KeyEventWorkaround.isMacControl(keyEvent) || c >= ' ' && c != '\u007f' && c != '\u00ff' || c == '\b' || c == '\t' || c == '\n')) {
                    return null;
                }
                if (Debug.DUMP_KEY_EVENTS) {
                    Log.log(1, "KEWa", "Key event (working around): " + AbstractInputHandler.toString(keyEvent) + ": last=" + last + ".");
                }
                if (!Debug.ALTERNATIVE_DISPATCHER && ((n2 & 2) != 0 && (n2 & 8) == 0 || (n2 & 2) == 0 && (n2 & 8) != 0 && !Debug.ALT_KEY_PRESSED_DISABLED || (n2 & 4) != 0)) {
                    return null;
                }
                if (last == 1) {
                    last = 0;
                    if ((c < '0' || c > '9') && c != '.' && c != '/' && c != '*' && c != '-' && c != '+') return keyEvent;
                    return null;
                }
                if (last != 2) return keyEvent;
                last = 0;
                switch (c) {
                    case '!': 
                    case ',': 
                    case '?': 
                    case 'B': 
                    case 'M': 
                    case 'X': 
                    case 'c': {
                        return null;
                    }
                }
                return keyEvent;
            }
            case 402: {
                switch (n) {
                    case 18: {
                        keyEvent.consume();
                        break block0;
                    }
                    case 16: 
                    case 17: 
                    case 157: 
                    case 65406: {
                        break block0;
                    }
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        if (n2 != 8) return keyEvent;
                        last = 2;
                    }
                }
            }
        }
        return keyEvent;
    }

    public static void numericKeypadKey() {
        last = 0;
    }
}

