/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;

class SelectionManager {
    List<Selection> selection;
    private final TextArea textArea;

    SelectionManager(TextArea textArea) {
        this.textArea = textArea;
        this.selection = new ArrayList<Selection>();
    }

    int getSelectionCount() {
        return this.selection.size();
    }

    @Nonnull
    public Selection[] getSelection() {
        return this.selection.toArray(new Selection[this.selection.size()]);
    }

    void setSelection(Selection[] selectionArray) {
        this.selection.clear();
        this.addToSelection(selectionArray);
    }

    void addToSelection(Selection[] selectionArray) {
        if (selectionArray != null) {
            for (int i = 0; i < selectionArray.length; ++i) {
                Selection selection = selectionArray[i];
                if (selection == null) continue;
                this.addToSelection(selection);
            }
        }
    }

    void addToSelection(Selection selection) {
        if (selection.start > selection.end) {
            throw new IllegalArgumentException(selection.start + " > " + selection.end);
        }
        if (selection.start == selection.end) {
            if (selection instanceof Selection.Range) {
                return;
            }
            if (selection instanceof Selection.Rect && ((Selection.Rect)selection).extraEndVirt == 0) {
                return;
            }
        }
        Iterator<Selection> iterator = this.selection.iterator();
        while (iterator.hasNext()) {
            Selection selection2 = iterator.next();
            if (!selection2.overlaps(selection)) continue;
            selection.start = Math.min(selection2.start, selection.start);
            selection.end = Math.max(selection2.end, selection.end);
            iterator.remove();
        }
        selection.startLine = this.textArea.getLineOfOffset(selection.start);
        selection.endLine = this.textArea.getLineOfOffset(selection.end);
        boolean bl = false;
        for (int i = 0; i < this.selection.size(); ++i) {
            Selection selection3 = this.selection.get(i);
            if (selection.start >= selection3.start) continue;
            this.selection.add(i, selection);
            bl = true;
            break;
        }
        if (!bl) {
            this.selection.add(selection);
        }
        this.textArea.invalidateLineRange(selection.startLine, selection.endLine);
    }

    void setSelection(Selection selection) {
        this.selection.clear();
        if (selection != null) {
            this.addToSelection(selection);
        }
    }

    Selection getSelectionAtOffset(int n) {
        if (this.selection != null) {
            for (Selection selection : this.selection) {
                if (n < selection.start || n > selection.end) continue;
                return selection;
            }
        }
        return null;
    }

    void removeFromSelection(Selection selection) {
        this.selection.remove(selection);
    }

    void resizeSelection(int n, int n2, int n3, boolean bl) {
        Selection selection;
        boolean bl2 = false;
        if (n2 < n) {
            int n4 = n;
            n = n2;
            n2 = n4;
            bl2 = true;
        }
        if (bl) {
            Selection.Rect rect = new Selection.Rect(n, n2);
            if (bl2) {
                rect.extraStartVirt = n3;
            } else {
                rect.extraEndVirt = n3;
            }
            selection = rect;
        } else {
            selection = new Selection.Range(n, n2);
        }
        this.addToSelection(selection);
    }

    int[] getSelectedLines() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Selection selection : this.selection) {
            int n = selection.end == this.textArea.getLineStartOffset(selection.endLine) ? selection.endLine - 1 : selection.endLine;
            for (int i = selection.startLine; i <= n; ++i) {
                treeSet.add(i);
            }
        }
        Object object = new int[treeSet.size()];
        int n = 0;
        for (Integer n2 : treeSet) {
            object[n++] = n2;
        }
        return object;
    }

    void invertSelection() {
        Selection[] selectionArray = new Selection[this.selection.size() + 1];
        int n = 0;
        for (int i = 0; i < this.selection.size(); ++i) {
            Selection selection = this.selection.get(i);
            selectionArray[i] = new Selection.Range(n, selection.getStart());
            n = selection.getEnd();
        }
        selectionArray[this.selection.size()] = new Selection.Range(n, this.textArea.getBufferLength());
        this.setSelection(selectionArray);
    }

    int[] getSelectionStartAndEnd(int n, int n2, Selection selection) {
        int n3;
        int n4;
        int n5 = this.textArea.getScreenLineStartOffset(n);
        int n6 = this.textArea.getScreenLineEndOffset(n);
        if (n6 <= selection.start || n5 > selection.end) {
            return null;
        }
        int n7 = this.textArea.displayManager.isLineVisible(selection.startLine) ? this.textArea.getScreenLineOfOffset(selection.start) : -1;
        int n8 = this.textArea.displayManager.isLineVisible(selection.endLine) ? this.textArea.getScreenLineOfOffset(selection.end) : -1;
        JEditBuffer jEditBuffer = this.textArea.getBuffer();
        int n9 = jEditBuffer.getLineStartOffset(n2);
        if (selection instanceof Selection.Rect) {
            n5 -= n9;
            n6 -= n9;
            Selection.Rect rect = (Selection.Rect)selection;
            int n10 = rect.getStartColumn(jEditBuffer);
            int n11 = rect.getEndColumn(jEditBuffer);
            int n12 = jEditBuffer.getLineLength(n2);
            int[] nArray = new int[1];
            int n13 = jEditBuffer.getOffsetOfVirtualColumn(n2, n10, nArray);
            if (n13 == -1) {
                n4 = (n10 - nArray[0]) * this.textArea.charWidth;
                n13 = n12;
            } else {
                n4 = 0;
            }
            int n14 = jEditBuffer.getOffsetOfVirtualColumn(n2, n11, nArray);
            if (n14 == -1) {
                n3 = (n11 - nArray[0]) * this.textArea.charWidth;
                n14 = n12;
            } else {
                n3 = 0;
            }
            if (n6 <= n13 || n5 > n14) {
                return null;
            }
            n4 = n13 < n5 ? 0 : n4 + this.textArea.offsetToXY((int)n2, (int)n13).x;
            n3 = n14 > n6 ? this.textArea.getWidth() : n3 + this.textArea.offsetToXY((int)n2, (int)n14).x;
        } else if (n7 == n8 && n7 != -1) {
            n4 = this.textArea.offsetToXY((int)n2, (int)(selection.start - n9)).x;
            n3 = this.textArea.offsetToXY((int)n2, (int)(selection.end - n9)).x;
        } else if (n == n7) {
            n4 = this.textArea.offsetToXY((int)n2, (int)(selection.start - n9)).x;
            n3 = this.textArea.getWidth();
        } else if (n == n8) {
            n4 = 0;
            n3 = this.textArea.offsetToXY((int)n2, (int)(selection.end - n9)).x;
        } else {
            n4 = 0;
            n3 = this.textArea.getWidth();
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 == n3) {
            // empty if block
        }
        return new int[]{n4, ++n3};
    }

    boolean insideSelection(int n, int n2) {
        int n3 = this.textArea.xyToOffset(n, n2);
        Selection selection = this.textArea.getSelectionAtOffset(n3);
        if (selection == null) {
            return false;
        }
        int n4 = this.textArea.getScreenLineOfOffset(n3);
        if (n4 == -1) {
            return false;
        }
        int[] nArray = this.getSelectionStartAndEnd(n4, this.textArea.getLineOfOffset(n3), selection);
        if (nArray == null) {
            return false;
        }
        return n >= nArray[0] && n <= nArray[1];
    }
}

