/*
 * Decompiled with CFR 0.152.
 */
package whitespace;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;
import whitespace.WhiteSpaceModel;

public class BufferOptionsOptionPane
extends AbstractOptionPane
implements ActionListener {
    private static final String[] asOpts = new String[]{" space-highlight", ">leading-space-highlight", ">inner-space-highlight", ">trailing-space-highlight", "-", " tab-highlight", ">leading-tab-highlight", ">inner-tab-highlight", ">trailing-tab-highlight", "-", " whitespace-highlight", " block-highlight", " fold-highlight", " fold-tooltip", "-options.whitespace.onBufferSave.label", " remove-trailing-white-space", " soft-tabify-leading-white-space", " tabify-leading-white-space", " untabify-leading-white-space"};
    private Map<String, JCheckBox> cbmap = new HashMap<String, JCheckBox>();
    private WhiteSpaceModel model;

    public BufferOptionsOptionPane(WhiteSpaceModel model) {
        super(jEdit.getProperty((String)"whitespace.buffer-options-dialog"));
        this.model = model;
    }

    protected void _init() {
        for (int i = 0; i < asOpts.length; ++i) {
            if (!asOpts[i].startsWith("-")) {
                String sOption = asOpts[i].substring(1);
                String sProp = "white-space.toggle-" + sOption + ".label";
                if (sOption.equals("space-highlight")) {
                    sProp = "options.whitespace.space-highlight.label";
                }
                if (sOption.equals("tab-highlight")) {
                    sProp = "options.whitespace.tab-highlight.label";
                }
                JCheckBox cb = new JCheckBox(jEdit.getProperty((String)sProp));
                WhiteSpaceModel.Option o = this.model.getOption(sOption);
                cb.setSelected(o.isEnabled());
                cb.addActionListener(this);
                cb.setName(sOption);
                this.cbmap.put(sOption, cb);
                this.addComponent(cb, 13);
                if (!asOpts[i].startsWith(">")) continue;
                this.moveRight(cb);
                continue;
            }
            String sepProp = asOpts[i].substring(1);
            if (sepProp.length() == 0) {
                this.addSeparator();
                continue;
            }
            this.addSeparator(sepProp);
        }
        this.updateState(null, false);
    }

    protected void _save() {
        for (int i = 0; i < asOpts.length; ++i) {
            if (asOpts[i].startsWith("-")) continue;
            String sOption = asOpts[i].substring(1);
            JCheckBox cb = this.cbmap.get(sOption);
            WhiteSpaceModel.Option o = this.model.getOption(sOption);
            o.setEnabled(cb.isSelected());
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)e.getSource();
            String name = cb.getName();
            this.updateState(name, cb.isSelected());
        }
    }

    private void updateState(String name, boolean on) {
        boolean bTabs = this.cbmap.get("tab-highlight").isSelected();
        this.cbmap.get("leading-tab-highlight").setEnabled(bTabs);
        this.cbmap.get("inner-tab-highlight").setEnabled(bTabs);
        this.cbmap.get("trailing-tab-highlight").setEnabled(bTabs);
        boolean bSpaces = this.cbmap.get("space-highlight").isSelected();
        this.cbmap.get("leading-space-highlight").setEnabled(bSpaces);
        this.cbmap.get("inner-space-highlight").setEnabled(bSpaces);
        this.cbmap.get("trailing-space-highlight").setEnabled(bSpaces);
        if (name != null && name.indexOf("tabify") >= 0 && on) {
            this.cbmap.get("soft-tabify-leading-white-space").setSelected(false);
            this.cbmap.get("tabify-leading-white-space").setSelected(false);
            this.cbmap.get("untabify-leading-white-space").setSelected(false);
            this.cbmap.get(name).setSelected(true);
        }
    }

    private void moveRight(Component c) {
        LayoutManager layout = this.getLayout();
        if (layout instanceof GridBagLayout) {
            GridBagLayout bag = (GridBagLayout)layout;
            GridBagConstraints cons = bag.getConstraints(c);
            cons.insets.left = c.getFontMetrics(c.getFont()).getHeight();
            bag.setConstraints(c, cons);
        }
    }
}

