/*
 * Decompiled with CFR 0.152.
 */
package whitespace;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.StandardUtilities;

public class DocumentUtilities {
    private DocumentUtilities() {
    }

    public static void untabifyLeading(JEditBuffer buffer, int tabSize) {
        WhiteSpaceInfo whiteSpaceInfo = new WhiteSpaceInfo();
        for (int i = buffer.getLineCount() - 1; i >= 0; --i) {
            int start = buffer.getLineStartOffset(i);
            int end = buffer.getLineEndOffset(i);
            int len = end - 1 - start;
            if (len == 0) continue;
            Segment s = new Segment();
            buffer.getText(start, len, s);
            DocumentUtilities.getLeadingWhiteSpaceInfo(s.array, s.offset, s.count, tabSize, whiteSpaceInfo);
            if (!whiteSpaceInfo.hasTabs || whiteSpaceInfo.len <= 0) continue;
            String textOut = StandardUtilities.createWhiteSpace((int)whiteSpaceInfo.expandedLen, (int)0);
            buffer.remove(start, whiteSpaceInfo.len);
            buffer.insert(start, textOut);
        }
    }

    public static void tabifyLeading(JEditBuffer buffer, int tabSize) {
        WhiteSpaceInfo whiteSpaceInfo = new WhiteSpaceInfo();
        for (int i = buffer.getLineCount() - 1; i >= 0; --i) {
            int start = buffer.getLineStartOffset(i);
            int end = buffer.getLineEndOffset(i);
            int len = end - 1 - start;
            if (len == 0) continue;
            Segment s = new Segment();
            buffer.getText(start, len, s);
            DocumentUtilities.getLeadingWhiteSpaceInfo(s.array, s.offset, s.count, tabSize, whiteSpaceInfo);
            if (!whiteSpaceInfo.hasSpaces || whiteSpaceInfo.len <= 0) continue;
            String textOut = StandardUtilities.createWhiteSpace((int)whiteSpaceInfo.expandedLen, (int)tabSize);
            buffer.remove(start, whiteSpaceInfo.len);
            buffer.insert(start, textOut);
        }
    }

    public static void removeTrailingWhiteSpace(JEditBuffer buffer, String escapeChars) {
        block0: for (int i = buffer.getLineCount() - 1; i >= 0; --i) {
            int start = buffer.getLineStartOffset(i);
            int end = buffer.getLineEndOffset(i);
            int len = end - 1 - start;
            if (len == 0) continue;
            Segment s = new Segment();
            buffer.getText(start, len, s);
            int off = s.offset + s.count - 1;
            int cnt = 0;
            while (off >= s.offset) {
                char c = s.array[off];
                if (c != ' ' && c != '\t') {
                    if (escapeChars.indexOf(c) != -1 && cnt > 0) {
                        ++off;
                        --cnt;
                    }
                    if (cnt <= 0) continue block0;
                    buffer.remove(end - 1 - cnt, cnt);
                    continue block0;
                }
                if (off == s.offset) {
                    buffer.remove(start, len);
                    continue block0;
                }
                --off;
                ++cnt;
            }
        }
    }

    private static void getLeadingWhiteSpaceInfo(char[] array, int off, int len, int tabSize, WhiteSpaceInfo results) {
        int resultLen = 0;
        int resultExpandedLen = 0;
        boolean hasTabs = false;
        boolean hasSpaces = false;
        int i = len - 1;
        block4: while (i >= 0) {
            char c = array[off];
            switch (c) {
                case '\t': {
                    hasTabs = true;
                    ++resultLen;
                    resultExpandedLen += tabSize - resultExpandedLen % tabSize;
                    break;
                }
                case ' ': {
                    hasSpaces = true;
                    ++resultLen;
                    ++resultExpandedLen;
                    break;
                }
                default: {
                    break block4;
                }
            }
            --i;
            ++off;
        }
        results.len = resultLen;
        results.expandedLen = resultExpandedLen;
        results.hasTabs = hasTabs;
        results.hasSpaces = hasSpaces;
    }

    private static class WhiteSpaceInfo {
        public int len = 0;
        public int expandedLen = 0;
        public boolean hasTabs = false;
        public boolean hasSpaces = false;

        public WhiteSpaceInfo() {
            this(0, 0, false, false);
        }

        public WhiteSpaceInfo(int len, int expandedLen, boolean hasTabs, boolean hasSpaces) {
            this.len = len;
            this.expandedLen = expandedLen;
            this.hasTabs = hasTabs;
            this.hasSpaces = hasSpaces;
        }
    }
}

