/*
 * Decompiled with CFR 0.152.
 */
package whitespace;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Hashtable;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import whitespace.WhiteSpaceModel;

public class WhiteSpaceHighlight
extends TextAreaExtension {
    private static final String[] ASCII_CONTROLS = new String[]{"NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL", "BS", "HT", "LF", "VT", "FF", "CR", "SO", "SI", "DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB", "CAN", "EM", "SUB", "ESC", "FS", "GS", "RS", "US"};
    private static Hashtable highlights = new Hashtable();
    private static Color spaceColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"white-space.space-color"));
    private static Color tabColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"white-space.tab-color"));
    private static Color whitespaceColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"white-space.whitespace-color"));
    private static boolean displayControlChars = jEdit.getBooleanProperty((String)"white-space.display-control-chars", (boolean)false);
    private static Painter spacePainter = new SpacePainter();
    private static Painter tabPainter = new TabPainter();
    private static Painter whitespacePainter = new WhiteSpacePainter();
    private JEditTextArea textArea;
    private Segment lineSegment = new Segment();

    private WhiteSpaceHighlight(JEditTextArea textArea) {
        this.textArea = textArea;
    }

    public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
        WhiteSpaceModel model = this.getModel();
        if (model != null && (model.getSpaceHighlight().isEnabled() || model.getTabHighlight().isEnabled() || model.getWhitespaceHighlight().isEnabled())) {
            JEditTextArea ta = this.textArea;
            Segment s = this.lineSegment;
            try {
                if (ta.getLineStartOffset(physicalLine) == -1 || ta.getLineEndOffset(physicalLine) == -1) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
            FontMetrics fm = ta.getPainter().getFontMetrics();
            ta.getLineText(physicalLine, s);
            int height = fm.getHeight();
            Point p0 = new Point();
            char[] array = s.array;
            int count = s.count;
            Painter[] spacePainters = new Painter[]{null, null, null};
            Painter[] tabPainters = new Painter[]{null, null, null};
            if (model.getSpaceHighlight().isEnabled()) {
                if (model.getLeadingSpaceHighlight().isEnabled()) {
                    spacePainters[0] = spacePainter;
                }
                if (model.getInnerSpaceHighlight().isEnabled()) {
                    spacePainters[1] = spacePainter;
                }
                if (model.getTrailingSpaceHighlight().isEnabled()) {
                    spacePainters[2] = spacePainter;
                }
            }
            if (model.getTabHighlight().isEnabled()) {
                if (model.getLeadingTabHighlight().isEnabled()) {
                    tabPainters[0] = tabPainter;
                }
                if (model.getInnerTabHighlight().isEnabled()) {
                    tabPainters[1] = tabPainter;
                }
                if (model.getTrailingTabHighlight().isEnabled()) {
                    tabPainters[2] = tabPainter;
                }
            }
            int i_t = count - 1;
            int idx_t = s.offset + i_t;
            Painter painter = null;
            while (i_t >= 0) {
                char c = array[idx_t];
                if (c == ' ') {
                    painter = spacePainters[2];
                } else {
                    if (c != '\t') break;
                    painter = tabPainters[2];
                }
                if (painter != null) {
                    ta.offsetToXY(physicalLine, i_t, p0);
                    painter.paint(gfx, p0.x + 1, p0.y + height / 2);
                    painter = null;
                }
                --i_t;
                --idx_t;
            }
            int i_l = 0;
            int idx_l = s.offset;
            painter = null;
            while (i_l < count) {
                char c = array[idx_l];
                if (c == ' ') {
                    painter = spacePainters[0];
                } else {
                    if (c != '\t') break;
                    painter = tabPainters[0];
                }
                if (painter != null) {
                    ta.offsetToXY(physicalLine, i_l, p0);
                    painter.paint(gfx, p0.x + 1, p0.y + height / 2);
                    painter = null;
                }
                ++i_l;
                ++idx_l;
            }
            int i_i = i_l;
            int idx_i = idx_l;
            painter = null;
            while (i_i <= i_t) {
                char c = array[idx_i];
                if (c == ' ') {
                    painter = spacePainters[1];
                } else if (c == '\t') {
                    painter = tabPainters[1];
                } else if ((Character.isWhitespace(c) || displayControlChars && Character.isISOControl(c)) && c != '\t' && c != ' ' && model.getWhitespaceHighlight().isEnabled()) {
                    painter = whitespacePainter;
                }
                if (painter != null) {
                    ta.offsetToXY(physicalLine, i_i, p0);
                    painter.paint(gfx, p0.x + 1, p0.y + height / 2);
                    painter = null;
                }
                ++i_i;
                ++idx_i;
            }
        }
    }

    public String getToolTipText(int x, int y) {
        WhiteSpaceModel model = this.getModel();
        if (model == null || !model.getWhitespaceHighlight().isEnabled()) {
            return null;
        }
        JEditTextArea ta = this.textArea;
        int offset = ta.xyToOffset(x, y, false);
        if (offset == -1 || offset >= ta.getBuffer().getLength()) {
            return null;
        }
        String s = ta.getText(offset, 1);
        if (s == null) {
            return null;
        }
        char c = s.charAt(0);
        if ((Character.isWhitespace(c) || displayControlChars && Character.isISOControl(c)) && c != '\t' && c != '\n' && c != ' ') {
            char i = c;
            String tooltip = i + " - " + "0x" + Integer.toHexString(i);
            if (i >= '\u0000' && i < ASCII_CONTROLS.length) {
                tooltip = tooltip + " - " + ASCII_CONTROLS[i];
                if (i >= '\u0007' && i <= '\r') {
                    String c_escape = "abtnvfr";
                    tooltip = tooltip + " (\\" + c_escape.charAt(i - 7) + ")";
                }
            }
            return tooltip;
        }
        return null;
    }

    public WhiteSpaceModel getModel() {
        return (WhiteSpaceModel)this.textArea.getBuffer().getProperty((Object)"white-space.model");
    }

    private void updateTextArea() {
        if (this.textArea == null) {
            return;
        }
        DisplayManager displayManager = this.textArea.getDisplayManager();
        int physicalFirst = displayManager.getFirstVisibleLine();
        int physicalLast = displayManager.getLastVisibleLine();
        this.textArea.invalidateLineRange(physicalFirst, physicalLast);
    }

    public static void updateTextAreas(Buffer buffer) {
        View[] views = jEdit.getViews();
        for (int i = 0; i < views.length; ++i) {
            EditPane[] editPanes = views[i].getEditPanes();
            for (int j = 0; j < editPanes.length; ++j) {
                WhiteSpaceHighlight highlight;
                if (editPanes[j].getBuffer() != buffer || (highlight = (WhiteSpaceHighlight)((Object)highlights.get(editPanes[j]))) == null) continue;
                highlight.updateTextArea();
            }
        }
    }

    public static TextAreaExtension getHighlightFor(EditPane editPane) {
        return (TextAreaExtension)highlights.get(editPane);
    }

    public static TextAreaExtension addHighlightTo(EditPane editPane) {
        JEditTextArea textArea = editPane.getTextArea();
        TextAreaPainter painter = textArea.getPainter();
        WhiteSpaceHighlight highlight = null;
        highlight = (WhiteSpaceHighlight)((Object)painter.getClientProperty(WhiteSpaceHighlight.class));
        if (highlight == null) {
            highlight = new WhiteSpaceHighlight(textArea);
            highlights.put(editPane, highlight);
            painter.addExtension(0, (TextAreaExtension)highlight);
            painter.putClientProperty(WhiteSpaceHighlight.class, (Object)highlight);
        }
        return highlight;
    }

    public static void removeHighlightFrom(EditPane editPane) {
        WhiteSpaceHighlight highlight = (WhiteSpaceHighlight)((Object)editPane.getTextArea().getPainter().getClientProperty(WhiteSpaceHighlight.class));
        if (highlight != null) {
            editPane.getTextArea().getPainter().removeExtension((TextAreaExtension)highlight);
            editPane.getTextArea().getPainter().putClientProperty(WhiteSpaceHighlight.class, null);
        }
        highlights.remove(editPane);
    }

    public static void propertiesChanged() {
        boolean displayControlCharsChanged;
        Color newSpaceColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"white-space.space-color"));
        Color newTabColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"white-space.tab-color"));
        Color newWhitespaceColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"white-space.whitespace-color"));
        boolean newDisplayControlChars = jEdit.getBooleanProperty((String)"white-space.display-control-chars", (boolean)false);
        boolean spaceColorChanged = !newSpaceColor.equals(spaceColor);
        boolean tabColorChanged = !newTabColor.equals(tabColor);
        boolean whitespaceColorChanged = !newWhitespaceColor.equals(whitespaceColor);
        boolean bl = displayControlCharsChanged = newDisplayControlChars != displayControlChars;
        if (!(spaceColorChanged || tabColorChanged || whitespaceColorChanged || displayControlCharsChanged)) {
            return;
        }
        spaceColor = newSpaceColor;
        tabColor = newTabColor;
        whitespaceColor = newWhitespaceColor;
        displayControlChars = newDisplayControlChars;
        View[] views = jEdit.getViews();
        for (int i = 0; i < views.length; ++i) {
            EditPane[] editPanes = views[i].getEditPanes();
            for (int j = 0; j < editPanes.length; ++j) {
                WhiteSpaceModel model;
                WhiteSpaceHighlight highlight = (WhiteSpaceHighlight)((Object)highlights.get(editPanes[j]));
                if (highlight == null || (model = highlight.getModel()) == null || !(spaceColorChanged && model.getSpaceHighlight().isEnabled() || tabColorChanged && model.getTabHighlight().isEnabled()) && (!whitespaceColorChanged || !model.getWhitespaceHighlight().isEnabled())) continue;
                highlight.updateTextArea();
            }
        }
    }

    private static class WhiteSpacePainter
    implements Painter {
        private WhiteSpacePainter() {
        }

        public void paint(Graphics2D gfx, int x0, int y0) {
            gfx.setColor(whitespaceColor);
            gfx.setColor(whitespaceColor);
            int[] xl0 = new int[]{x0, x0 + 2, x0 + 4, x0 + 2};
            int[] yl0 = new int[]{y0, y0 - 2, y0, y0 + 2};
            gfx.drawPolygon(xl0, yl0, 4);
        }
    }

    private static class TabPainter
    implements Painter {
        private TabPainter() {
        }

        public void paint(Graphics2D gfx, int x0, int y0) {
            gfx.setColor(tabColor);
            int[] xl0 = new int[]{x0, x0 + 2, x0};
            int[] xl1 = new int[]{x0 + 2, x0 + 4, x0 + 2};
            int[] yl0 = new int[]{y0 - 2, y0, y0 + 2};
            gfx.drawPolyline(xl0, yl0, 3);
            gfx.drawPolyline(xl1, yl0, 3);
        }
    }

    private static class SpacePainter
    implements Painter {
        private SpacePainter() {
        }

        public void paint(Graphics2D gfx, int x0, int y0) {
            gfx.setColor(spaceColor);
            gfx.drawRect(x0 + 1, y0 - 1, 2, 2);
        }
    }

    private static interface Painter {
        public void paint(Graphics2D var1, int var2, int var3);
    }
}

