/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;

public class LineManager {
    private int[] endOffsets = new int[1];
    private short[] foldLevels;
    private TokenMarker.LineContext[] lineContext;
    private int lineCount;
    private int gapLine;
    private int gapWidth;
    private int firstInvalidLineContext;
    private int firstInvalidFoldLevel;
    private int getLineOfOffsetLine = -1;

    public LineManager() {
        this.endOffsets[0] = 1;
        this.foldLevels = new short[1];
        this.lineContext = new TokenMarker.LineContext[1];
        this.lineCount = 1;
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    public int getLineOfOffset(int n) {
        int n2;
        int n3;
        if (this.getLineOfOffsetLine > 0 && this.getLineOfOffsetLine < this.lineCount) {
            n3 = this.getLineEndOffset(this.getLineOfOffsetLine - 1);
            n2 = this.getLineEndOffset(this.getLineOfOffsetLine);
            if (n >= n3 && n < n2) {
                return this.getLineOfOffsetLine;
            }
        }
        n3 = 0;
        n2 = this.lineCount - 1;
        while (true) {
            switch (n2 - n3) {
                case 0: {
                    this.getLineOfOffsetLine = this.getLineEndOffset(n3) <= n ? n3 + 1 : n3;
                    return this.getLineOfOffsetLine;
                }
                case 1: {
                    this.getLineOfOffsetLine = this.getLineEndOffset(n3) <= n ? (this.getLineEndOffset(n2) <= n ? n2 + 1 : n2) : n3;
                    return this.getLineOfOffsetLine;
                }
            }
            int n4 = (n2 + n3) / 2;
            int n5 = this.getLineEndOffset(n4);
            if (n5 == n) {
                this.getLineOfOffsetLine = n4 + 1;
                return this.getLineOfOffsetLine;
            }
            if (n5 < n) {
                n3 = n4 + 1;
                continue;
            }
            n2 = n4 - 1;
        }
    }

    public final int getLineEndOffset(int n) {
        if (this.gapLine != -1 && n >= this.gapLine) {
            return this.endOffsets[n] + this.gapWidth;
        }
        return this.endOffsets[n];
    }

    public final int getFoldLevel(int n) {
        return this.foldLevels[n];
    }

    public final void setFoldLevel(int n, int n2) {
        if (n2 > 65535) {
            n2 = 65535;
        }
        this.foldLevels[n] = (short)n2;
    }

    public void setFirstInvalidFoldLevel(int n) {
        this.firstInvalidFoldLevel = n;
    }

    public int getFirstInvalidFoldLevel() {
        return this.firstInvalidFoldLevel;
    }

    public final TokenMarker.LineContext getLineContext(int n) {
        return this.lineContext[n];
    }

    public final void setLineContext(int n, TokenMarker.LineContext lineContext) {
        this.lineContext[n] = lineContext;
    }

    public void setFirstInvalidLineContext(int n) {
        this.firstInvalidLineContext = n;
    }

    public int getFirstInvalidLineContext() {
        return this.firstInvalidLineContext;
    }

    public void _contentInserted(IntegerArray integerArray) {
        this.gapLine = -1;
        this.gapWidth = 0;
        this.firstInvalidFoldLevel = 0;
        this.firstInvalidLineContext = 0;
        this.lineCount = integerArray.getSize();
        this.endOffsets = integerArray.getArray();
        this.foldLevels = new short[this.lineCount];
        this.lineContext = new TokenMarker.LineContext[this.lineCount];
    }

    public void contentInserted(int n, int n2, int n3, int n4, IntegerArray integerArray) {
        int n5 = n + n3;
        if (n3 > 0) {
            Object[] objectArray;
            this.lineCount += n3;
            if (this.endOffsets.length <= this.lineCount) {
                objectArray = new int[(this.lineCount + 1) * 2];
                System.arraycopy(this.endOffsets, 0, objectArray, 0, this.endOffsets.length);
                this.endOffsets = objectArray;
            }
            if (this.foldLevels.length <= this.lineCount) {
                objectArray = new short[(this.lineCount + 1) * 2];
                System.arraycopy(this.foldLevels, 0, objectArray, 0, this.foldLevels.length);
                this.foldLevels = (short[])objectArray;
            }
            if (this.lineContext.length <= this.lineCount) {
                objectArray = new TokenMarker.LineContext[(this.lineCount + 1) * 2];
                System.arraycopy(this.lineContext, 0, objectArray, 0, this.lineContext.length);
                this.lineContext = (TokenMarker.LineContext[])objectArray;
            }
            System.arraycopy(this.endOffsets, n, this.endOffsets, n5, this.lineCount - n5);
            System.arraycopy(this.foldLevels, n, this.foldLevels, n5, this.lineCount - n5);
            System.arraycopy(this.lineContext, n, this.lineContext, n5, this.lineCount - n5);
            if (n <= this.gapLine) {
                this.gapLine += n3;
            } else if (this.gapLine != -1) {
                n2 -= this.gapWidth;
            }
            if (n < this.firstInvalidLineContext) {
                this.firstInvalidLineContext += n3;
            }
            for (int i = 0; i < n3; ++i) {
                this.endOffsets[n + i] = n2 + integerArray.get(i);
                this.foldLevels[n + i] = 0;
            }
        }
        if (this.firstInvalidFoldLevel == -1 || this.firstInvalidFoldLevel > n) {
            this.firstInvalidFoldLevel = n;
        }
        this.moveGap(n5, n4, "contentInserted");
    }

    public void contentRemoved(int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        if (n3 > 0) {
            if (n + n3 < this.gapLine) {
                this.gapLine -= n3;
            } else if (n < this.gapLine) {
                this.gapLine = n;
            }
            if (n + n3 < this.firstInvalidLineContext) {
                this.firstInvalidLineContext -= n3;
            } else if (n < this.firstInvalidLineContext) {
                this.firstInvalidLineContext = n - 1;
            }
            this.lineCount -= n3;
            System.arraycopy(this.endOffsets, n5, this.endOffsets, n, this.lineCount - n);
            System.arraycopy(this.foldLevels, n5, this.foldLevels, n, this.lineCount - n);
            System.arraycopy(this.lineContext, n5, this.lineContext, n, this.lineCount - n);
        }
        if (this.firstInvalidFoldLevel == -1 || this.firstInvalidFoldLevel > n) {
            this.firstInvalidFoldLevel = n;
        }
        this.moveGap(n, -n4, "contentRemoved");
    }

    private final void setLineEndOffset(int n, int n2) {
        this.endOffsets[n] = n2;
    }

    private final void moveGap(int n, int n2, String string) {
        if (this.gapLine == -1) {
            this.gapWidth = n2;
        } else if (n == -1) {
            if (this.gapWidth != 0) {
                if (Debug.OFFSET_DEBUG && this.gapLine != this.lineCount) {
                    Log.log(1, this, string + ": update from " + this.gapLine + " to " + this.lineCount + " width " + this.gapWidth);
                }
                for (int i = this.gapLine; i < this.lineCount; ++i) {
                    this.setLineEndOffset(i, this.getLineEndOffset(i));
                }
            }
            this.gapWidth = n2;
        } else if (n < this.gapLine) {
            if (this.gapWidth != 0) {
                if (Debug.OFFSET_DEBUG && n != this.gapLine) {
                    Log.log(1, this, string + ": update from " + n + " to " + this.gapLine + " width " + this.gapWidth);
                }
                for (int i = n; i < this.gapLine; ++i) {
                    this.setLineEndOffset(i, this.getLineEndOffset(i) - this.gapWidth);
                }
            }
            this.gapWidth += n2;
        } else {
            if (this.gapWidth != 0) {
                if (Debug.OFFSET_DEBUG && this.gapLine != n) {
                    Log.log(1, this, string + ": update from " + this.gapLine + " to " + n + " width " + this.gapWidth);
                }
                for (int i = this.gapLine; i < n; ++i) {
                    this.setLineEndOffset(i, this.getLineEndOffset(i));
                }
            }
            this.gapWidth += n2;
        }
        this.gapLine = n == this.lineCount ? -1 : n;
    }
}

