/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.bufferset.BufferSetListener;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class BufferSet {
    private final List<Buffer> buffers;
    private final EventListenerList listeners;
    private static final Comparator<Buffer> nameSorter = new NameSorter();
    private static final Comparator<Buffer> pathSorter = new PathSorter();
    private Comparator<Buffer> sorter;

    public BufferSet(BufferSet bufferSet) {
        this.buffers = bufferSet == null ? Collections.synchronizedList(new ArrayList()) : Collections.synchronizedList(new ArrayList<Buffer>(bufferSet.buffers));
        this.listeners = new EventListenerList();
        if (jEdit.getBooleanProperty("sortBuffers")) {
            this.sorter = jEdit.getBooleanProperty("sortByName") ? nameSorter : pathSorter;
        }
    }

    public void addBuffer(Buffer buffer) {
        this.addBufferAt(buffer, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBufferAt(Buffer buffer, int n) {
        Log.log(1, this, this.hashCode() + " addBufferAt(" + buffer + ',' + n + ')');
        BufferSetListener[] bufferSetListenerArray = null;
        BufferSetListener[] bufferSetListenerArray2 = this.buffers;
        synchronized (this.buffers) {
            BufferSetListener[] bufferSetListenerArray3;
            if (this.buffers.size() == 1 && (bufferSetListenerArray3 = this.buffers.get(0)).isUntitled() && !bufferSetListenerArray3.isDirty()) {
                bufferSetListenerArray = bufferSetListenerArray3;
            }
            if (this.sorter != null) {
                if (this.buffers.contains(buffer)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                this.buffers.add(buffer);
                Collections.sort(this.buffers, this.sorter);
                n = this.buffers.indexOf(buffer);
            } else {
                int n2 = this.buffers.indexOf(buffer);
                if (n2 != -1) {
                    if (n == -1) {
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return;
                    }
                    this.moveBuffer(n2, n);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                int n3 = this.buffers.size();
                if (n == -1 || n > n3) {
                    n = n3;
                }
                this.buffers.add(n, buffer);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            bufferSetListenerArray2 = (BufferSetListener[])this.listeners.getListeners(BufferSetListener.class);
            Log.log(1, this, this.hashCode() + ": Buffer added " + buffer + " at " + n);
            for (BufferSetListener bufferSetListener : bufferSetListenerArray2) {
                bufferSetListener.bufferAdded(buffer, n);
            }
            if (bufferSetListenerArray != null) {
                jEdit.getBufferSetManager().removeBuffer(this, (Buffer)bufferSetListenerArray);
            }
            return;
        }
    }

    public Buffer getBuffer(int n) {
        return this.buffers.get(n);
    }

    public Buffer getPreviousBuffer(int n) {
        if (this.buffers.isEmpty()) {
            return null;
        }
        if (this.buffers.size() < 2) {
            return this.buffers.get(0);
        }
        if (n <= 0) {
            return this.buffers.get(this.buffers.size() - 1);
        }
        return this.buffers.get(n - 1);
    }

    public Buffer getNextBuffer(int n) {
        if (this.buffers.isEmpty()) {
            return null;
        }
        if (this.buffers.size() < 2) {
            return this.buffers.get(this.buffers.size() - 1);
        }
        if (n >= this.buffers.size() - 1) {
            return this.buffers.get(0);
        }
        return this.buffers.get(n + 1);
    }

    public int indexOf(Buffer buffer) {
        return this.buffers.indexOf(buffer);
    }

    public int size() {
        return this.buffers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllBuffers(BufferSetListener bufferSetListener) {
        List<Buffer> list = this.buffers;
        synchronized (list) {
            for (int i = 0; i < this.buffers.size(); ++i) {
                Buffer buffer = this.buffers.get(i);
                Log.log(1, this, this.hashCode() + ": Buffer added " + buffer + " at " + i);
                bufferSetListener.bufferAdded(buffer, i);
            }
        }
    }

    public Buffer[] getAllBuffers() {
        Buffer[] bufferArray = new Buffer[this.buffers.size()];
        return this.buffers.toArray(bufferArray);
    }

    public void addBufferSetListener(BufferSetListener bufferSetListener) {
        Log.log(1, this, this.hashCode() + ": addBufferSetListener " + bufferSetListener);
        this.listeners.add(BufferSetListener.class, bufferSetListener);
    }

    public void removeBufferSetListener(BufferSetListener bufferSetListener) {
        Log.log(1, this, this.hashCode() + ": removeBufferSetListener " + bufferSetListener);
        this.listeners.remove(BufferSetListener.class, bufferSetListener);
    }

    public String toString() {
        return "BufferSet[nbBuffers=" + this.size() + ']';
    }

    public void sort() {
        BufferSetListener[] bufferSetListenerArray;
        if (this.sorter == null) {
            return;
        }
        Collections.sort(this.buffers, this.sorter);
        for (BufferSetListener bufferSetListener : bufferSetListenerArray = (BufferSetListener[])this.listeners.getListeners(BufferSetListener.class)) {
            bufferSetListener.bufferSetSorted();
        }
    }

    void propertiesChanged() {
        if (jEdit.getBooleanProperty("sortBuffers")) {
            this.sorter = jEdit.getBooleanProperty("sortByName") ? nameSorter : pathSorter;
            this.sort();
        } else {
            this.sorter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveBuffer(int n, int n2) {
        if (this.sorter != null) {
            return;
        }
        BufferSetListener[] bufferSetListenerArray = this.buffers;
        synchronized (this.buffers) {
            Buffer buffer = this.buffers.remove(n);
            int n3 = this.buffers.size();
            if (n2 == -1 || n2 > n3) {
                n2 = n3;
            }
            this.buffers.add(n2, buffer);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            bufferSetListenerArray = (BufferSetListener[])this.listeners.getListeners(BufferSetListener.class);
            Log.log(1, this, this.hashCode() + ": Buffer moved " + buffer + " from " + n + " to " + n2);
            for (BufferSetListener bufferSetListener : bufferSetListenerArray) {
                bufferSetListener.bufferMoved(buffer, n, n2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBuffer(Buffer buffer) {
        BufferSetListener[] bufferSetListenerArray = this.buffers;
        synchronized (this.buffers) {
            int n = this.buffers.indexOf(buffer);
            if (n == -1) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            this.buffers.remove(n);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            bufferSetListenerArray = (BufferSetListener[])this.listeners.getListeners(BufferSetListener.class);
            Log.log(1, this, this.hashCode() + ": Buffer removed " + buffer);
            for (BufferSetListener bufferSetListener : bufferSetListenerArray) {
                bufferSetListener.bufferRemoved(buffer, n);
            }
            return;
        }
    }

    private static class PathSorter
    implements Comparator<Buffer> {
        private PathSorter() {
        }

        @Override
        public int compare(Buffer buffer, Buffer buffer2) {
            return StandardUtilities.compareStrings(buffer.getPath(), buffer2.getPath(), true);
        }
    }

    private static class NameSorter
    implements Comparator<Buffer> {
        private NameSorter() {
        }

        @Override
        public int compare(Buffer buffer, Buffer buffer2) {
            int n = StandardUtilities.compareStrings(buffer.getName(), buffer2.getName(), true);
            if (n == 0) {
                n = StandardUtilities.compareStrings(buffer.getPath(), buffer2.getPath(), true);
            }
            return n;
        }
    }

    public static enum Scope {
        editpane,
        view,
        global;

    }
}

