/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.gjt.sp.jedit.gui.ExtendedGridLayoutConstraints;

public class ExtendedGridLayout
implements LayoutManager2 {
    private final Hashtable<Component, ExtendedGridLayoutConstraints> comptable;
    private final int hgap;
    private final int vgap;
    private final Insets distanceToBorders;

    public ExtendedGridLayout(int n, int n2, Insets insets) {
        if (n < 0) {
            throw new IllegalArgumentException("hgap must be non-negative (" + n + ')');
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("vgap must be non-negative (" + n2 + ')');
        }
        this.hgap = n;
        this.vgap = n2;
        this.distanceToBorders = (Insets)insets.clone();
        this.comptable = new Hashtable();
    }

    public ExtendedGridLayout() {
        this(0, 0, new Insets(0, 0, 0, 0));
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        ExtendedGridLayoutConstraints extendedGridLayoutConstraints;
        if (null == object) {
            object = new ExtendedGridLayoutConstraints(component);
        }
        if (object instanceof ExtendedGridLayoutConstraints) {
            extendedGridLayoutConstraints = (ExtendedGridLayoutConstraints)object;
            if (extendedGridLayoutConstraints.isPlaceholder()) {
                throw new IllegalArgumentException("constraints must not be a placeholder");
            }
            if (component != extendedGridLayoutConstraints.getComponent()) {
                throw new IllegalArgumentException("constraints is not the right one for this component");
            }
        } else {
            throw new IllegalArgumentException("constraints must not be an ExtendedGridLayoutConstraints object");
        }
        this.comptable.put(component, extendedGridLayoutConstraints);
    }

    private ExtendedGridLayoutConstraints lookupConstraints(Component component) {
        if (null == component) {
            throw new NullPointerException("component must not be null");
        }
        ExtendedGridLayoutConstraints extendedGridLayoutConstraints = this.comptable.get(component);
        if (null == extendedGridLayoutConstraints) {
            extendedGridLayoutConstraints = new ExtendedGridLayoutConstraints(component);
            this.comptable.put(component, extendedGridLayoutConstraints);
        }
        return extendedGridLayoutConstraints;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.comptable.remove(component);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            ArrayList<List<ExtendedGridLayoutConstraints>> arrayList = new ArrayList<List<ExtendedGridLayoutConstraints>>();
            HashSet<ExtendedGridLayoutConstraints> hashSet = new HashSet<ExtendedGridLayoutConstraints>();
            HashSet<ExtendedGridLayoutConstraints> hashSet2 = new HashSet<ExtendedGridLayoutConstraints>();
            Dimension dimension = this.buildGrid(container, arrayList, hashSet, hashSet2);
            return this.getSize(container, LayoutSize.MINIMUM, false, dimension, arrayList, hashSet, hashSet2, new int[0][0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            ArrayList<List<ExtendedGridLayoutConstraints>> arrayList = new ArrayList<List<ExtendedGridLayoutConstraints>>();
            HashSet<ExtendedGridLayoutConstraints> hashSet = new HashSet<ExtendedGridLayoutConstraints>();
            HashSet<ExtendedGridLayoutConstraints> hashSet2 = new HashSet<ExtendedGridLayoutConstraints>();
            Dimension dimension = this.buildGrid(container, arrayList, hashSet, hashSet2);
            return this.getSize(container, LayoutSize.PREFERRED, false, dimension, arrayList, hashSet, hashSet2, new int[0][0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            ArrayList<List<ExtendedGridLayoutConstraints>> arrayList = new ArrayList<List<ExtendedGridLayoutConstraints>>();
            HashSet<ExtendedGridLayoutConstraints> hashSet = new HashSet<ExtendedGridLayoutConstraints>();
            HashSet<ExtendedGridLayoutConstraints> hashSet2 = new HashSet<ExtendedGridLayoutConstraints>();
            Dimension dimension = this.buildGrid(container, arrayList, hashSet, hashSet2);
            return this.getSize(container, LayoutSize.MAXIMUM, false, dimension, arrayList, hashSet, hashSet2, new int[0][0]);
        }
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            ArrayList<List<ExtendedGridLayoutConstraints>> arrayList = new ArrayList<List<ExtendedGridLayoutConstraints>>();
            HashSet<ExtendedGridLayoutConstraints> hashSet = new HashSet<ExtendedGridLayoutConstraints>();
            HashSet<ExtendedGridLayoutConstraints> hashSet2 = new HashSet<ExtendedGridLayoutConstraints>();
            Dimension dimension = this.buildGrid(container, arrayList, hashSet, hashSet2);
            int[][] nArrayArray = new int[6][];
            Dimension dimension2 = this.getSize(container, LayoutSize.PREFERRED, true, dimension, arrayList, hashSet, hashSet2, nArrayArray);
            int[] nArray = nArrayArray[0];
            int[] nArray2 = nArrayArray[1];
            int[] nArray3 = nArrayArray[2];
            int[] nArray4 = nArrayArray[3];
            int[] nArray5 = nArrayArray[4];
            int[] nArray6 = nArrayArray[5];
            Dimension dimension3 = container.getSize();
            Insets insets = container.getInsets();
            int n = dimension3.width - insets.left - insets.right - (dimension.width - 1) * this.hgap - this.distanceToBorders.left - this.distanceToBorders.right;
            int n2 = dimension3.height - insets.top - insets.bottom - (dimension.height - 1) * this.vgap - this.distanceToBorders.top - this.distanceToBorders.bottom;
            this.redistributeSpace(dimension2.width, n, 0, dimension.width, nArray3, nArray, nArray5);
            this.redistributeSpace(dimension2.height, n2, 0, dimension.height, nArray4, nArray2, nArray6);
            int n3 = insets.top + this.distanceToBorders.top;
            for (int i = 0; i < dimension.height; ++i) {
                List list = (List)arrayList.get(i);
                int n4 = insets.left + this.distanceToBorders.left;
                for (int j = 0; j < dimension.width; ++j) {
                    ExtendedGridLayoutConstraints extendedGridLayoutConstraints = (ExtendedGridLayoutConstraints)list.get(j);
                    if (null != extendedGridLayoutConstraints && null != extendedGridLayoutConstraints.getComponent() && !extendedGridLayoutConstraints.isPlaceholder()) {
                        int n5;
                        int n6;
                        Component component = extendedGridLayoutConstraints.getComponent();
                        Dimension dimension4 = component.getMaximumSize();
                        int n7 = extendedGridLayoutConstraints.getCol();
                        int n8 = extendedGridLayoutConstraints.getEffectiveColspan();
                        int n9 = n7 + n8;
                        int n10 = 0;
                        for (n6 = n7; n6 < n9; ++n6) {
                            n10 += nArray3[n6];
                        }
                        n10 += (n8 - 1) * this.hgap;
                        n6 = extendedGridLayoutConstraints.getRow();
                        int n11 = extendedGridLayoutConstraints.getEffectiveRowspan();
                        int n12 = n6 + n11;
                        int n13 = 0;
                        for (n5 = n6; n5 < n12; ++n5) {
                            n13 += nArray4[n5];
                        }
                        n13 += (n11 - 1) * this.vgap;
                        n5 = 0;
                        int n14 = 0;
                        if (n10 > dimension4.width) {
                            n5 = (int)((float)(n10 - dimension4.width) * component.getAlignmentX());
                            n10 = dimension4.width;
                        }
                        if (n13 > dimension4.height) {
                            n14 = (int)((float)(n13 - dimension4.height) * component.getAlignmentY());
                            n13 = dimension4.height;
                        }
                        component.setBounds(n4 + n5, n3 + n14, n10, n13);
                    }
                    n4 += nArray3[j] + this.hgap;
                }
                n3 += nArray4[i] + this.vgap;
            }
        }
    }

    private void redistributeSpace(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3) {
        if (n != n2) {
            boolean bl = n < n2;
            n2 = (n2 - n) * (bl ? 1 : -1);
            while (n2 > 0) {
                int n5;
                int n6;
                int n7 = 0;
                long l = 0L;
                for (n6 = n3; n6 < n4; ++n6) {
                    if ((!bl || nArray[n6] >= nArray3[n6]) && (bl || nArray[n6] <= nArray2[n6])) continue;
                    ++n7;
                    l += (long)nArray[n6];
                }
                n6 = 1;
                if (0 == n7) {
                    for (n5 = n3; n5 < n4; ++n5) {
                        l += (long)nArray[n5];
                    }
                    n6 = 0;
                    n7 = n4 - n3;
                }
                if (l == 0L) break;
                if (n2 < n7) {
                    for (n5 = n3; n5 < n4; ++n5) {
                        if (n2 == 0 || n6 != 0 && (n6 == 0 || !bl || nArray[n5] >= nArray3[n5]) && (bl || nArray[n5] <= nArray2[n5])) continue;
                        int n8 = n5;
                        nArray[n8] = nArray[n8] + (bl ? 1 : -1);
                        if (0 > nArray[n5]) {
                            nArray[n5] = 0;
                        }
                        --n2;
                    }
                    continue;
                }
                long l2 = 0L;
                double d = (double)((long)n2 + l) / (double)l;
                for (int i = n3; i < n4; ++i) {
                    long l3 = n6 != 0 ? (bl ? nArray3[i] - nArray[i] : nArray[i] - nArray2[i]) : Integer.MAX_VALUE - nArray[i];
                    long l4 = Math.abs(Math.round(d * (double)nArray[i] - (double)nArray[i]));
                    if (l4 <= l3) {
                        int n9 = i;
                        nArray[n9] = (int)((long)nArray[n9] + (bl ? l4 : -l4));
                        l2 += bl ? l4 : -l4;
                        n2 = (int)((long)n2 - l4);
                    } else {
                        int n10 = i;
                        nArray[n10] = (int)((long)nArray[n10] + (bl ? l3 : -l3));
                        l2 += bl ? l3 : -l3;
                        n2 = (int)((long)n2 - l3);
                    }
                    if (0 <= nArray[i]) continue;
                    nArray[i] = 0;
                }
                l += l2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Dimension getSize(Container container, LayoutSize layoutSize, boolean bl, Dimension dimension, List<List<ExtendedGridLayoutConstraints>> list, Set<ExtendedGridLayoutConstraints> set, Set<ExtendedGridLayoutConstraints> set2, int[][] nArray) {
        void var16_29;
        int[] nArray2;
        int n;
        Component component;
        int n2;
        int n3;
        int n42;
        int n5;
        int n6;
        if (bl && nArray.length < 6) {
            throw new IllegalArgumentException("If fillRawSizes is true, resultArrays.length must be >= 6 (" + nArray.length + ')');
        }
        int[] nArray3 = new int[dimension.width];
        int[] nArray4 = new int[dimension.height];
        int[] nArray5 = new int[dimension.width];
        int[] nArray6 = new int[dimension.height];
        int[] nArray7 = new int[dimension.width];
        int[] nArray8 = new int[dimension.height];
        Arrays.fill(nArray3, 0);
        Arrays.fill(nArray4, 0);
        Arrays.fill(nArray5, 0);
        Arrays.fill(nArray6, 0);
        Arrays.fill(nArray7, 0);
        Arrays.fill(nArray8, 0);
        for (n6 = 0; n6 < dimension.height; ++n6) {
            List<ExtendedGridLayoutConstraints> object2 = list.get(n6);
            for (n5 = 0; n5 < dimension.width; ++n5) {
                ExtendedGridLayoutConstraints extendedGridLayoutConstraints = object2.get(n5);
                if (null == extendedGridLayoutConstraints || null == extendedGridLayoutConstraints.getComponent()) continue;
                Component component2 = extendedGridLayoutConstraints.getComponent();
                Dimension dimension2 = component2.getMinimumSize();
                Dimension dimension3 = component2.getPreferredSize();
                Dimension dimension4 = component2.getMaximumSize();
                if (!set.contains(extendedGridLayoutConstraints)) {
                    nArray3[n5] = Math.max(nArray3[n5], dimension2.width);
                    nArray5[n5] = Math.max(nArray5[n5], dimension3.width);
                    nArray7[n5] = Math.max(nArray7[n5], dimension4.width);
                }
                if (set2.contains(extendedGridLayoutConstraints)) continue;
                nArray4[n6] = Math.max(nArray4[n6], dimension2.height);
                nArray6[n6] = Math.max(nArray6[n6], dimension3.height);
                nArray8[n6] = Math.max(nArray8[n6], dimension4.height);
            }
        }
        for (n6 = 0; n6 < dimension.width; ++n6) {
            if (nArray3[n6] >= nArray7[n6]) {
                nArray7[n6] = nArray3[n6];
                nArray5[n6] = nArray3[n6];
                continue;
            }
            if (nArray5[n6] < nArray3[n6]) {
                nArray5[n6] = nArray3[n6];
                continue;
            }
            if (nArray5[n6] <= nArray7[n6]) continue;
            nArray5[n6] = nArray7[n6];
        }
        for (ExtendedGridLayoutConstraints extendedGridLayoutConstraints : set) {
            int n7;
            n5 = extendedGridLayoutConstraints.getCol();
            int n8 = extendedGridLayoutConstraints.getEffectiveColspan();
            int n9 = n5 + n8;
            int n10 = 0;
            boolean bl2 = false;
            int n11 = 0;
            for (int i = n5; i < n9; ++i) {
                n42 = nArray3[i];
                n10 = Integer.MAX_VALUE - n42 < n10 ? Integer.MAX_VALUE : (n10 += n42);
                n3 = nArray5[i];
                n7 = Integer.MAX_VALUE - n3 < n7 ? Integer.MAX_VALUE : (n7 += n3);
                n2 = nArray7[i];
                if (Integer.MAX_VALUE - n2 < n11) {
                    n11 = Integer.MAX_VALUE;
                    continue;
                }
                n11 += n2;
            }
            component = extendedGridLayoutConstraints.getComponent();
            n42 = component.getMaximumSize().width - (n8 - 1) * this.hgap;
            if (n11 < n42) {
                this.redistributeSpace(n11, n42, n5, n9, nArray7, nArray7, nArray7);
            }
            if (n10 < (n3 = component.getMinimumSize().width - (n8 - 1) * this.hgap)) {
                this.redistributeSpace(n10, n3, n5, n9, nArray3, nArray3, nArray7);
            }
            if (n7 >= (n2 = component.getPreferredSize().width - (n8 - 1) * this.hgap)) continue;
            this.redistributeSpace(n7, n2, n5, n9, nArray5, nArray3, nArray7);
        }
        for (n = 0; n < dimension.width; ++n) {
            if (nArray3[n] >= nArray7[n]) {
                nArray7[n] = nArray3[n];
                nArray5[n] = nArray3[n];
                continue;
            }
            if (nArray5[n] < nArray3[n]) {
                nArray5[n] = nArray3[n];
                continue;
            }
            if (nArray5[n] <= nArray7[n]) continue;
            nArray5[n] = nArray7[n];
        }
        for (n = 0; n < dimension.height; ++n) {
            if (nArray4[n] >= nArray8[n]) {
                nArray8[n] = nArray4[n];
                nArray6[n] = nArray4[n];
                continue;
            }
            if (nArray6[n] < nArray4[n]) {
                nArray6[n] = nArray4[n];
                continue;
            }
            if (nArray6[n] <= nArray8[n]) continue;
            nArray6[n] = nArray8[n];
        }
        for (ExtendedGridLayoutConstraints extendedGridLayoutConstraints : set2) {
            int n12;
            n5 = extendedGridLayoutConstraints.getRow();
            int n13 = extendedGridLayoutConstraints.getEffectiveRowspan();
            int n14 = n5 + n13;
            int n15 = 0;
            boolean bl3 = false;
            int n16 = 0;
            for (int i = n5; i < n14; ++i) {
                n42 = nArray4[i];
                n15 = Integer.MAX_VALUE - n42 < n15 ? Integer.MAX_VALUE : (n15 += n42);
                n3 = nArray6[i];
                n12 = Integer.MAX_VALUE - n3 < n12 ? Integer.MAX_VALUE : (n12 += n3);
                n2 = nArray8[i];
                if (Integer.MAX_VALUE - n2 < n16) {
                    n16 = Integer.MAX_VALUE;
                    continue;
                }
                n16 += n2;
            }
            component = extendedGridLayoutConstraints.getComponent();
            n42 = component.getMaximumSize().height - (n13 - 1) * this.vgap;
            if (n16 < n42) {
                this.redistributeSpace(n16, n42, n5, n14, nArray8, nArray8, nArray8);
            }
            if (n15 < (n3 = component.getMinimumSize().height - (n13 - 1) * this.vgap)) {
                this.redistributeSpace(n15, n3, n5, n14, nArray4, nArray4, nArray8);
            }
            if (n12 >= (n2 = component.getPreferredSize().height - (n13 - 1) * this.vgap)) continue;
            this.redistributeSpace(n12, n2, n5, n14, nArray6, nArray4, nArray8);
        }
        for (int i = 0; i < dimension.height; ++i) {
            if (nArray4[i] >= nArray8[i]) {
                nArray8[i] = nArray4[i];
                nArray6[i] = nArray4[i];
                continue;
            }
            if (nArray6[i] < nArray4[i]) {
                nArray6[i] = nArray4[i];
                continue;
            }
            if (nArray6[i] <= nArray8[i]) continue;
            nArray6[i] = nArray8[i];
        }
        if (bl) {
            nArray[0] = nArray3;
            nArray[1] = nArray4;
            nArray[2] = nArray5;
            nArray[3] = nArray6;
            nArray[4] = nArray7;
            nArray[5] = nArray8;
        }
        switch (layoutSize) {
            case MINIMUM: {
                nArray2 = nArray3;
                int[] nArray9 = nArray4;
                break;
            }
            case PREFERRED: {
                nArray2 = nArray5;
                int[] nArray10 = nArray6;
                break;
            }
            case MAXIMUM: {
                nArray2 = nArray7;
                int[] nArray11 = nArray8;
                break;
            }
            default: {
                throw new InternalError("Missing case branch for LayoutSize: " + (Object)((Object)layoutSize));
            }
        }
        long l = 0L;
        long l2 = 0L;
        for (int n42 : nArray2) {
            l += (long)n42;
        }
        for (int n42 : var16_29) {
            l2 += (long)n42;
        }
        if (!bl) {
            Insets insets = container.getInsets();
            l += (long)(insets.left + insets.right + (dimension.width - 1) * this.hgap + this.distanceToBorders.left + this.distanceToBorders.right);
            l2 += (long)(insets.top + insets.bottom + (dimension.height - 1) * this.vgap + this.distanceToBorders.top + this.distanceToBorders.bottom);
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, (int)l2);
    }

    /*
     * Could not resolve type clashes
     */
    private Dimension buildGrid(Container container, List<List<ExtendedGridLayoutConstraints>> list, Set<ExtendedGridLayoutConstraints> set, Set<ExtendedGridLayoutConstraints> set2) {
        ExtendedGridLayoutConstraints extendedGridLayoutConstraints;
        ExtendedGridLayoutConstraints extendedGridLayoutConstraints2;
        Object object;
        ArrayList arrayList = new ArrayList();
        Component[] componentArray = container.getComponents();
        for (Component component : componentArray) {
            int n;
            if (!component.isVisible()) continue;
            Object object2 = this.lookupConstraints(component).getWorkCopy();
            int n2 = arrayList.size();
            for (int i = n = ((ExtendedGridLayoutConstraints)object2).getRow(); i >= n2; --i) {
                arrayList.add(new ArrayList());
            }
            object = (ArrayList<Object>)arrayList.get(n);
            object.add(object2);
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        int n = 0;
        for (Object object2 : arrayList) {
            Iterator iterator = object2.iterator();
            arrayList2.add(iterator);
            if (iterator.hasNext()) {
                n = 1;
            }
            object = new ArrayList<Object>();
            list.add((List<ExtendedGridLayoutConstraints>)object);
            arrayList3.add(object.listIterator());
        }
        int n3 = -1;
        while (n != 0) {
            ++n3;
            n = 0;
            int n4 = list.size();
            for (int i = 0; i < n4; ++i) {
                object = (Iterator)arrayList2.get(i);
                ListIterator listIterator = (ListIterator)arrayList3.get(i);
                if (i > 0 && null != (extendedGridLayoutConstraints2 = list.get(i - 1).get(n3)) && null != (extendedGridLayoutConstraints = extendedGridLayoutConstraints2.getRowspanPlaceholder(true))) {
                    set2.add(extendedGridLayoutConstraints2);
                    listIterator.add(extendedGridLayoutConstraints);
                    if (null != extendedGridLayoutConstraints.getColspanPlaceholder(false)) {
                        switch (extendedGridLayoutConstraints.getColspan()) {
                            case 0x7FFFFFFF: {
                                break;
                            }
                            default: {
                                n = 1;
                                break;
                            }
                        }
                        continue;
                    }
                    if (!object.hasNext()) continue;
                    n = 1;
                    continue;
                }
                if (listIterator.hasPrevious()) {
                    extendedGridLayoutConstraints2 = (ExtendedGridLayoutConstraints)listIterator.previous();
                    listIterator.next();
                    if (null != extendedGridLayoutConstraints2 && null != (extendedGridLayoutConstraints = extendedGridLayoutConstraints2.getColspanPlaceholder(true))) {
                        set.add(extendedGridLayoutConstraints2);
                        listIterator.add(extendedGridLayoutConstraints);
                        if (null != extendedGridLayoutConstraints.getColspanPlaceholder(false)) {
                            switch (extendedGridLayoutConstraints.getColspan()) {
                                case 0x7FFFFFFF: {
                                    break;
                                }
                                default: {
                                    n = 1;
                                    break;
                                }
                            }
                            continue;
                        }
                        if (!object.hasNext()) continue;
                        n = 1;
                        continue;
                    }
                }
                if (object.hasNext()) {
                    extendedGridLayoutConstraints2 = (ExtendedGridLayoutConstraints)object.next();
                    extendedGridLayoutConstraints2.setCol(n3);
                    listIterator.add(extendedGridLayoutConstraints2);
                    if (null != extendedGridLayoutConstraints2.getColspanPlaceholder(false)) {
                        switch (extendedGridLayoutConstraints2.getColspan()) {
                            case 0x7FFFFFFF: {
                                break;
                            }
                            default: {
                                n = 1;
                                break;
                            }
                        }
                        continue;
                    }
                    if (!object.hasNext()) continue;
                    n = 1;
                    continue;
                }
                listIterator.add(null);
            }
        }
        n = 0;
        int n5 = list.size();
        if (n5 > 0) {
            ListIterator<ExtendedGridLayoutConstraints> listIterator = list.get(list.size() - 1).listIterator();
            while (listIterator.hasNext()) {
                object = listIterator.next();
                if (null == object || Integer.MAX_VALUE == ((ExtendedGridLayoutConstraints)object).getRowspan() || null == ((ExtendedGridLayoutConstraints)object).getRowspanPlaceholder(false)) continue;
                n = 1;
                break;
            }
            block15: while (n != 0) {
                n = 0;
                listIterator = list.get(list.size() - 1).listIterator();
                object = new ArrayList();
                list.add((List<ExtendedGridLayoutConstraints>)object);
                ListIterator<ExtendedGridLayoutConstraints> listIterator2 = object.listIterator();
                while (listIterator.hasNext()) {
                    extendedGridLayoutConstraints2 = listIterator.next();
                    if (null != extendedGridLayoutConstraints2 && null != extendedGridLayoutConstraints2.getRowspanPlaceholder(false)) {
                        set2.add(extendedGridLayoutConstraints2);
                        extendedGridLayoutConstraints = extendedGridLayoutConstraints2.getRowspanPlaceholder(true);
                        listIterator2.add(extendedGridLayoutConstraints);
                        continue;
                    }
                    listIterator2.add(null);
                }
                listIterator = object.listIterator();
                while (listIterator.hasNext()) {
                    extendedGridLayoutConstraints2 = listIterator.next();
                    if (null == extendedGridLayoutConstraints2 || Integer.MAX_VALUE == extendedGridLayoutConstraints2.getRowspan() || null == extendedGridLayoutConstraints2.getRowspanPlaceholder(false)) continue;
                    n = 1;
                    continue block15;
                }
            }
        }
        return new Dimension(n3 + 1, list.size());
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",distanceToBorders=" + this.distanceToBorders + ",comptable=" + this.comptable + "]";
    }

    private static enum LayoutSize {
        MINIMUM,
        PREFERRED,
        MAXIMUM;

    }
}

