/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskListener;
import org.gjt.sp.util.TaskManager;

public class TaskMonitorWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        TaskMonitorWidget taskMonitorWidget = new TaskMonitorWidget(view);
        taskMonitorWidget.getComponent().setToolTipText(jEdit.getProperty("statusbar.task-monitor.tooltip"));
        return taskMonitorWidget;
    }

    private static class TaskMonitorWidget
    extends JLabel
    implements Widget,
    TaskListener {
        private TaskMonitorWidget(final View view) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        view.getDockableWindowManager().showDockableWindow("task-monitor");
                    }
                }
            });
        }

        @Override
        public void addNotify() {
            super.addNotify();
            TaskManager.instance.addTaskListener(this);
            this.update();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            TaskManager.instance.removeTaskListener(this);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public void propertiesChanged() {
        }

        @Override
        public void update() {
            int n = TaskManager.instance.countTasks();
            if (n == 0) {
                this.setText(null);
            } else {
                this.setText(jEdit.getProperty("statusbar.task-monitor.template", new Object[]{Integer.toString(n)}));
            }
        }

        @Override
        public void waiting(Task task) {
            this.update();
        }

        @Override
        public void running(Task task) {
            this.update();
        }

        @Override
        public void done(Task task) {
            this.update();
        }

        @Override
        public void statusUpdated(Task task) {
            this.update();
        }

        @Override
        public void maximumUpdated(Task task) {
            this.update();
        }

        @Override
        public void valueUpdated(Task task) {
            this.update();
        }
    }
}

