/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.Autosave;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.EditServer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.JEditKillRing;
import org.gjt.sp.jedit.JEditMode;
import org.gjt.sp.jedit.JEditRegisterSaver;
import org.gjt.sp.jedit.JEditRegistersListener;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.ModeCatalogHandler;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.PropertyManager;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.SettingsReloader;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.datatransfer.JEditTransferableService;
import org.gjt.sp.jedit.datatransfer.TransferHandler;
import org.gjt.sp.jedit.gui.ActionBar;
import org.gjt.sp.jedit.gui.CloseDialog;
import org.gjt.sp.jedit.gui.DefaultInputHandler;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.DockingLayoutManager;
import org.gjt.sp.jedit.gui.ErrorListDialog;
import org.gjt.sp.jedit.gui.FilesChangedDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.JEditHistoryModelSaver;
import org.gjt.sp.jedit.gui.TipOfTheDay;
import org.gjt.sp.jedit.gui.tray.JTrayIconManager;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.io.CharsetEncoding;
import org.gjt.sp.jedit.io.FavoritesVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.jedit.msg.EditorExitRequested;
import org.gjt.sp.jedit.msg.EditorExiting;
import org.gjt.sp.jedit.msg.EditorStarted;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.syntax.XModeHandler;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.visitors.JEditVisitor;
import org.gjt.sp.jedit.visitors.SaveCaretInfoVisitor;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.StringList;
import org.gjt.sp.util.SyntaxUtilities;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.XMLUtilities;
import org.jedit.core.MigrationService;
import org.jedit.keymap.KeymapManager;
import org.jedit.keymap.KeymapManagerImpl;
import org.jedit.migration.OneTimeMigrationService;
import org.xml.sax.SAXParseException;

public class jEdit {
    private static String jEditHome;
    private static String settingsDirectory;
    private static String jarCacheDirectory;
    private static long propsModTime;
    private static PropertyManager propMgr;
    private static EditServer server;
    private static boolean background;
    private static ActionContext actionContext;
    private static ActionSet builtInActionSet;
    private static Vector<ErrorListDialog.ErrorEntry> pluginErrors;
    private static final Object pluginErrorLock;
    private static Vector<PluginJAR> jars;
    private static final JEditPropertyManager propertyManager;
    private static long startupTime;
    private static boolean saveCaret;
    private static InputHandler inputHandler;
    private static KeymapManager keymapManager;
    private static BufferSetManager bufferSetManager;
    private static boolean sortBuffers;
    private static boolean sortByName;
    private static int bufferCount;
    private static Buffer buffersFirst;
    private static Buffer buffersLast;
    private static Map<String, Buffer> bufferHash;
    private static final Object bufferListLock;
    private static final Object editBusOrderingLock;
    private static int viewCount;
    private static View viewsFirst;
    private static View viewsLast;
    private static View activeView;
    private static final List<Boolean> startupDone;
    private static Vector<String> additionalFiles;
    private static Thread mainThread;

    public static String getVersion() {
        return MiscUtilities.buildToVersion(jEdit.getBuild());
    }

    public static String getBuild() {
        return "05.01.99.00";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String[] stringArray2;
        BufferedWriter bufferedWriter;
        Object object;
        Object object3;
        Object object4;
        StringList stringList = new StringList(stringArray);
        String string = System.getProperty("java.version");
        if (string.compareTo("1.6") < 0) {
            System.err.println("You are running Java version " + string + '.');
            System.err.println("jEdit requires Java 1.6 or later.");
            System.exit(1);
        }
        startupDone.add(false);
        mainThread = Thread.currentThread();
        settingsDirectory = MiscUtilities.constructPath(System.getProperty("user.home"), ".jedit");
        if (OperatingSystem.isMacOS()) {
            settingsDirectory = MiscUtilities.constructPath(System.getProperty("user.home"), "Library/jEdit");
        } else if (OperatingSystem.isWindows() && (object4 = System.getenv("APPDATA")) != null) {
            settingsDirectory = MiscUtilities.constructPath((String)object4, "jEdit");
        }
        background = OperatingSystem.isMacOS();
        if (OperatingSystem.isX11()) {
            try {
                object4 = Toolkit.getDefaultToolkit();
                Field field = object4.getClass().getDeclaredField("awtAppClassName");
                field.setAccessible(true);
                field.set(object4, System.getProperty("x11.wmclass", "jedit"));
            }
            catch (Exception exception) {
                Log.log(9, jEdit.class, exception);
            }
        }
        boolean bl = false;
        int n = 7;
        String string2 = "server";
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = true;
        boolean bl7 = true;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = true;
        String string3 = System.getProperty("user.dir");
        boolean bl11 = true;
        String string4 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            object3 = stringArray[i];
            if (object3 == null) continue;
            if (((String)object3).length() == 0) {
                stringArray[i] = null;
                continue;
            }
            if (!((String)object3).startsWith("-") || bl) continue;
            if (((String)object3).equals("--")) {
                bl = true;
            } else if (((String)object3).equals("-usage")) {
                jEdit.version();
                System.err.println();
                jEdit.usage();
                System.exit(1);
            } else if (((String)object3).equals("-version")) {
                jEdit.version();
                System.exit(1);
            } else if (((String)object3).startsWith("-log=")) {
                try {
                    n = Integer.parseInt(((String)object3).substring("-log=".length()));
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Malformed option: " + (String)object3);
                }
            } else if (((String)object3).equals("-nosettings")) {
                settingsDirectory = null;
            } else if (((String)object3).startsWith("-settings=")) {
                settingsDirectory = ((String)object3).substring(10);
                bl10 = false;
            } else if (((String)object3).startsWith("-noserver")) {
                string2 = null;
            } else if (((String)object3).equals("-server")) {
                string2 = "server";
            } else if (((String)object3).startsWith("-server=")) {
                string2 = ((String)object3).substring(8);
            } else if (((String)object3).startsWith("-background")) {
                background = true;
            } else if (((String)object3).startsWith("-nobackground")) {
                background = false;
            } else if (((String)object3).equals("-gui")) {
                bl5 = true;
            } else if (((String)object3).equals("-nogui")) {
                bl5 = false;
            } else if (((String)object3).equals("-newview")) {
                bl3 = true;
            } else if (((String)object3).equals("-newplainview")) {
                bl4 = true;
            } else if (((String)object3).equals("-reuseview")) {
                bl3 = false;
                bl4 = false;
            } else if (((String)object3).equals("-restore")) {
                bl2 = true;
            } else if (((String)object3).equals("-norestore")) {
                bl2 = false;
            } else if (((String)object3).equals("-plugins")) {
                bl6 = true;
            } else if (((String)object3).equals("-noplugins")) {
                bl6 = false;
            } else if (((String)object3).equals("-startupscripts")) {
                bl7 = true;
            } else if (((String)object3).equals("-nostartupscripts")) {
                bl7 = false;
            } else if (((String)object3).startsWith("-run=")) {
                string4 = ((String)object3).substring(5);
            } else if (((String)object3).equals("-wait")) {
                bl9 = true;
            } else if (((String)object3).equals("-quit")) {
                bl8 = true;
            } else if (((String)object3).equals("-nosplash")) {
                bl11 = false;
            } else {
                System.err.println("Unknown option: " + (String)object3);
                jEdit.usage();
                System.exit(1);
            }
            stringArray[i] = null;
        }
        JTrayIconManager.setTrayIconArgs(bl2, string3, stringArray);
        if (settingsDirectory != null) {
            settingsDirectory = MiscUtilities.resolveSymlinks(settingsDirectory);
        }
        string2 = settingsDirectory != null && string2 != null ? MiscUtilities.constructPath(settingsDirectory, string2) : null;
        Log.init(true, n);
        Log.log(3, jEdit.class, "starting with command line arguments: " + stringList.join(" "));
        if (string2 != null && new File(string2).exists()) {
            BufferedReader bufferedReader = null;
            object3 = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string2));
                String object2 = bufferedReader.readLine();
                if (!"b".equals(object2)) {
                    throw new IllegalArgumentException("Wrong port file format");
                }
                int n2 = Integer.parseInt(bufferedReader.readLine());
                int n3 = Integer.parseInt(bufferedReader.readLine());
                Socket socket = new Socket(InetAddress.getByName(null), n2);
                object3 = new DataOutputStream(socket.getOutputStream());
                ((DataOutputStream)object3).writeInt(n3);
                object = bl8 ? "socket.close();\njEdit.exit(null,true);\n" : jEdit.makeServerScript(bl9, bl2, bl3, bl4, stringArray, string4);
                ((DataOutputStream)object3).writeUTF((String)object);
                Log.log(1, jEdit.class, "Waiting for server");
                socket.getInputStream().read();
                System.exit(0);
            }
            catch (Exception iOException) {
                Log.log(5, jEdit.class, "An error occurred while connecting to the jEdit server instance.");
                Log.log(5, jEdit.class, "This probably means that jEdit crashed and/or exited abnormally");
                Log.log(5, jEdit.class, "the last time it was run.");
                Log.log(5, jEdit.class, "If you don't know what this means, don't worry.");
                Log.log(5, jEdit.class, iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (object3 != null) {
                    try {
                        ((FilterOutputStream)object3).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (bl8) {
            System.exit(0);
        }
        if (OperatingSystem.isMacOS() && !new File(settingsDirectory, "noquartz").exists()) {
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
        }
        jEdit.logTime("before splash screen activation");
        if (bl11 && !new File(settingsDirectory, "nosplash").exists()) {
            GUIUtilities.showSplashScreen();
        }
        jEdit.logTime("after splash screen activation");
        if ((OperatingSystem.isMacOS() || OperatingSystem.isWindows()) && bl10 && settingsDirectory != null) {
            jEdit.relocateSettings();
        }
        if (settingsDirectory != null) {
            File file;
            object3 = new File(settingsDirectory);
            if (!((File)object3).exists()) {
                ((File)object3).mkdirs();
            }
            if (!(file = new File(settingsDirectory, "macros")).exists()) {
                file.mkdir();
            }
            String string5 = MiscUtilities.constructPath(settingsDirectory, "activity.log");
            jEdit.backupSettingsFile(new File(string5));
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(string5));
                String string6 = System.getProperty("line.separator");
                bufferedWriter.write("Log file created on " + new Date());
                bufferedWriter.write(string6);
                bufferedWriter.write("IMPORTANT:");
                bufferedWriter.write(string6);
                bufferedWriter.write("Because updating this file after every log message would kill");
                bufferedWriter.write(string6);
                bufferedWriter.write("performance, it will be *incomplete* unless you invoke the");
                bufferedWriter.write(string6);
                bufferedWriter.write("Utilities->Troubleshooting->Update Activity Log on Disk command!");
                bufferedWriter.write(string6);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bufferedWriter = null;
            }
        } else {
            bufferedWriter = null;
        }
        Log.setLogWriter(bufferedWriter);
        Log.log(5, jEdit.class, "jEdit version " + jEdit.getVersion());
        Log.log(3, jEdit.class, "Settings directory is " + settingsDirectory);
        GUIUtilities.advanceSplashProgress("init");
        jEdit.initMisc();
        GUIUtilities.advanceSplashProgress("init system properties");
        jEdit.initSystemProperties();
        GUIUtilities.advanceSplashProgress("init beanshell");
        BeanShell.init();
        GUIUtilities.advanceSplashProgress("loading site properties");
        if (jEditHome != null) {
            jEdit.initSiteProperties();
        }
        GUIUtilities.advanceSplashProgress("loading user properties");
        jEdit.initUserProperties();
        jEdit.initLocalizationProperties();
        GUIUtilities.advanceSplashProgress("init GUI");
        GUIUtilities.init();
        bufferSetManager = new BufferSetManager();
        if (string2 != null) {
            GUIUtilities.advanceSplashProgress("init server");
            server = new EditServer(string2);
            if (!server.isOK()) {
                server = null;
            }
        } else {
            GUIUtilities.advanceSplashProgress();
            if (background) {
                background = false;
                Log.log(7, jEdit.class, "You cannot specify both the -background and -noserver switches");
            }
        }
        GUIUtilities.advanceSplashProgress("init look and feel");
        jEdit.initPLAF();
        GUIUtilities.advanceSplashProgress("init VFS Manager");
        VFSManager.init();
        GUIUtilities.advanceSplashProgress("init resources");
        jEdit.initResources();
        if (settingsDirectory != null) {
            GUIUtilities.advanceSplashProgress("Migrate keymaps");
            object3 = ServiceManager.getService(MigrationService.class, "keymap");
            object3.migrate();
        }
        SearchAndReplace.load();
        if (bl6) {
            GUIUtilities.advanceSplashProgress("init plugins");
            jEdit.initPlugins();
        } else {
            GUIUtilities.advanceSplashProgress();
        }
        Registers.setSaver(new JEditRegisterSaver());
        Registers.setListener(new JEditRegistersListener());
        GUIUtilities.advanceSplashProgress("init history model");
        HistoryModel.setSaver(new JEditHistoryModelSaver());
        HistoryModel.loadHistory();
        GUIUtilities.advanceSplashProgress("init buffer history");
        BufferHistory.load();
        GUIUtilities.advanceSplashProgress("init killring");
        KillRing.setInstance(new JEditKillRing());
        KillRing.getInstance().load();
        GUIUtilities.advanceSplashProgress("init various properties");
        OneTimeMigrationService.execute();
        jEdit.propertiesChanged();
        GUIUtilities.advanceSplashProgress("init modes");
        sortBuffers = jEdit.getBooleanProperty("sortBuffers");
        sortByName = jEdit.getBooleanProperty("sortByName");
        jEdit.reloadModes();
        GUIUtilities.advanceSplashProgress("activate plugins");
        for (int i = 0; i < jars.size(); ++i) {
            jars.elementAt(i).activatePluginIfNecessary();
        }
        for (String string7 : stringArray2 = ServiceManager.getServiceNames(JEditTransferableService.class)) {
            object = ServiceManager.getService(JEditTransferableService.class, string7);
            TransferHandler.getInstance().registerTransferableService((JEditTransferableService)object);
        }
        GUIUtilities.advanceSplashProgress("init macros");
        Macros.loadMacros();
        Macros.getMacroActionSet().initKeyBindings();
        if (bl7 && jEditHome != null) {
            String string8 = MiscUtilities.constructPath(jEditHome, "startup");
            File file = new File(string8);
            if (file.exists()) {
                jEdit.runStartupScripts(file);
            } else {
                GUIUtilities.advanceSplashProgress();
            }
        } else {
            GUIUtilities.advanceSplashProgress("run startup scripts");
        }
        if (bl7 && settingsDirectory != null) {
            String string9 = MiscUtilities.constructPath(settingsDirectory, "startup");
            File file = new File(string9);
            if (file.exists()) {
                GUIUtilities.advanceSplashProgress("run startup scripts");
                jEdit.runStartupScripts(file);
            } else {
                GUIUtilities.advanceSplashProgress();
                file.mkdirs();
            }
        } else {
            GUIUtilities.advanceSplashProgress();
        }
        if (string4 != null) {
            GUIUtilities.advanceSplashProgress("run script file");
            string4 = MiscUtilities.constructPath(string3, string4);
            try {
                BeanShell.getNameSpace().setVariable("args", stringArray);
            }
            catch (UtilEvalError utilEvalError) {
                Log.log(9, jEdit.class, utilEvalError);
            }
            BeanShell.runScript(null, string4, null, false);
        } else {
            GUIUtilities.advanceSplashProgress();
        }
        GUIUtilities.advanceSplashProgress();
        DockingLayoutManager.init();
        SyntaxUtilities.propertyManager = propertyManager;
        jEdit.finishStartup(bl5, bl2, bl4, string3, stringArray);
        jEdit.logTime("main done");
    }

    public static String getCurrentLanguage() {
        String string = jEdit.getBooleanProperty("lang.usedefaultlocale") ? Locale.getDefault().getLanguage() : jEdit.getProperty("lang.current", "en");
        return string;
    }

    public static Properties getProperties() {
        return propMgr.getProperties();
    }

    public static String getProperty(String string) {
        return propMgr.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        String string3 = propMgr.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static String getProperty(String string, Object[] objectArray) {
        if (string == null) {
            return null;
        }
        if (objectArray == null) {
            return jEdit.getProperty(string);
        }
        String string2 = jEdit.getProperty(string);
        if (string2 == null) {
            return null;
        }
        return MessageFormat.format(string2, objectArray);
    }

    public static boolean getBooleanProperty(String string) {
        return jEdit.getBooleanProperty(string, false);
    }

    public static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = jEdit.getProperty(string);
        return StandardUtilities.getBoolean(string2, bl);
    }

    public static int getIntegerProperty(String string) {
        return jEdit.getIntegerProperty(string, 0);
    }

    public static int getIntegerProperty(String string, int n) {
        String string2 = jEdit.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static double getDoubleProperty(String string, double d) {
        String string2 = jEdit.getProperty(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static Font getFontProperty(String string) {
        return jEdit.getFontProperty(string, null);
    }

    public static Font getFontProperty(String string, Font font) {
        int n;
        int n2;
        String string2 = jEdit.getProperty(string);
        String string3 = jEdit.getProperty(string + "size");
        String string4 = jEdit.getProperty(string + "style");
        if (string2 == null || string3 == null || string4 == null) {
            return font;
        }
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return font;
        }
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            return font;
        }
        return new Font(string2, n, n2);
    }

    public static Color getColorProperty(String string) {
        return jEdit.getColorProperty(string, Color.black);
    }

    public static Color getColorProperty(String string, Color color) {
        String string2 = jEdit.getProperty(string);
        if (string2 == null) {
            return color;
        }
        return SyntaxUtilities.parseColor(string2, color);
    }

    public static void setColorProperty(String string, Color color) {
        jEdit.setProperty(string, SyntaxUtilities.getColorHexString(color));
    }

    public static void setProperty(String string, String string2) {
        propMgr.setProperty(string, string2);
    }

    public static void setTemporaryProperty(String string, String string2) {
        propMgr.setTemporaryProperty(string, string2);
    }

    public static void setBooleanProperty(String string, boolean bl) {
        jEdit.setProperty(string, bl ? "true" : "false");
    }

    public static void setIntegerProperty(String string, int n) {
        jEdit.setProperty(string, String.valueOf(n));
    }

    public static void setDoubleProperty(String string, double d) {
        jEdit.setProperty(string, String.valueOf(d));
    }

    public static void setFontProperty(String string, Font font) {
        jEdit.setProperty(string, font.getFamily());
        jEdit.setIntegerProperty(string + "size", font.getSize());
        jEdit.setIntegerProperty(string + "style", font.getStyle());
    }

    public static void unsetProperty(String string) {
        propMgr.unsetProperty(string);
    }

    public static void resetProperty(String string) {
        propMgr.resetProperty(string);
    }

    public static void propertiesChanged() {
        jEdit.initPLAF();
        keymapManager.reload();
        jEdit.initKeyBindings();
        Autosave.setInterval(jEdit.getIntegerProperty("autosave", 30));
        saveCaret = jEdit.getBooleanProperty("saveCaret");
        UIDefaults uIDefaults = UIManager.getDefaults();
        uIDefaults.put("SplitPane.continuousLayout", (Object)true);
        Font font = jEdit.getFontProperty("view.font");
        uIDefaults.put("TextArea.font", font);
        uIDefaults.put("TextPane.font", font);
        ToolTipManager.sharedInstance().setEnabled(jEdit.getBooleanProperty("showTooltips"));
        jEdit.initProxy();
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            buffer.resetCachedProperties();
            buffer.propertiesChanged();
            buffer = buffer.next;
        }
        HistoryModel.setDefaultMax(jEdit.getIntegerProperty("history", 25));
        HistoryModel.setDefaultMaxSize(jEdit.getIntegerProperty("historyMaxSize", 5000000));
        KillRing.getInstance().propertiesChanged(jEdit.getIntegerProperty("history", 25));
        Chunk.propertiesChanged(propertyManager);
        Log.setBeepOnOutput(jEdit.getBooleanProperty("debug.beepOnOutput"));
        if (jEdit.getBooleanProperty("systrayicon")) {
            JTrayIconManager.addTrayIcon();
        } else {
            JTrayIconManager.removeTrayIcon();
        }
        EditBus.send(new PropertiesChanged(null));
    }

    public static String[] getNotLoadedPluginJARs() {
        String[] stringArray;
        String[] stringArray2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jEditHome != null && (stringArray2 = new File((String)(stringArray = MiscUtilities.constructPath(jEditHome, "jars"))).list()) != null) {
            jEdit.getNotLoadedPluginJARs(arrayList, (String)stringArray, stringArray2);
        }
        if (settingsDirectory != null && (stringArray2 = new File((String)(stringArray = MiscUtilities.constructPath(settingsDirectory, "jars"))).list()) != null) {
            jEdit.getNotLoadedPluginJARs(arrayList, (String)stringArray, stringArray2);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static EditPlugin getPlugin(String string) {
        return jEdit.getPlugin(string, false);
    }

    public static EditPlugin getPlugin(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        EditPlugin[] editPluginArray = jEdit.getPlugins();
        EditPlugin editPlugin = null;
        for (EditPlugin editPlugin2 : editPluginArray) {
            if (!editPlugin2.getClassName().equals(string)) continue;
            editPlugin = editPlugin2;
            break;
        }
        if (!bl) {
            return editPlugin;
        }
        if (editPlugin instanceof EditPlugin.Deferred) {
            editPlugin.getPluginJAR().activatePlugin();
            editPlugin = editPlugin.getPluginJAR().getPlugin();
        }
        String string2 = PluginJAR.findPlugin(string);
        PluginJAR pluginJAR = PluginJAR.load(string2, true);
        return pluginJAR.getPlugin();
    }

    public static EditPlugin[] getPlugins() {
        ArrayList<EditPlugin> arrayList = new ArrayList<EditPlugin>();
        for (int i = 0; i < jars.size(); ++i) {
            EditPlugin editPlugin = jars.elementAt(i).getPlugin();
            if (editPlugin == null) continue;
            arrayList.add(editPlugin);
        }
        EditPlugin[] editPluginArray = new EditPlugin[arrayList.size()];
        arrayList.toArray(editPluginArray);
        return editPluginArray;
    }

    public static PluginJAR[] getPluginJARs() {
        Object[] objectArray = new PluginJAR[jars.size()];
        jars.copyInto(objectArray);
        return objectArray;
    }

    public static PluginJAR getPluginJAR(String string) {
        for (int i = 0; i < jars.size(); ++i) {
            PluginJAR pluginJAR = jars.elementAt(i);
            if (!pluginJAR.getPath().equals(string)) continue;
            return pluginJAR;
        }
        return null;
    }

    public static void addPluginJAR(String string) {
        PluginJAR pluginJAR = new PluginJAR(new File(string));
        jars.addElement(pluginJAR);
        if (pluginJAR.init()) {
            String string2 = MiscUtilities.getFileName(string);
            jEdit.unsetProperty("plugin-blacklist." + string2);
            jEdit.unsetProperty("plugin." + string2 + ".disabled");
            EditBus.send(new PluginUpdate(pluginJAR, PluginUpdate.LOADED, false));
            if (!jEdit.isMainThread()) {
                EditBus.send(new DynamicMenuChanged("plugins"));
                jEdit.initKeyBindings();
            }
        } else {
            jars.removeElement(pluginJAR);
            pluginJAR.uninit(false);
        }
    }

    private static void addPluginJARsFromDirectory(String string) {
        Log.log(5, jEdit.class, "Loading plugins from " + string);
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.toLowerCase().endsWith(".jar")) continue;
            String string3 = MiscUtilities.constructPath(string, string2);
            if (jEdit.getBooleanProperty("plugin-blacklist." + string2)) continue;
            jEdit.addPluginJAR(string3);
        }
    }

    public static void removePluginJAR(PluginJAR pluginJAR, boolean bl) {
        if (bl) {
            pluginJAR.uninit(true);
        } else {
            pluginJAR.uninit(false);
            jars.removeElement(pluginJAR);
            if (!jEdit.isMainThread()) {
                jEdit.initKeyBindings();
            }
        }
        EditBus.send(new PluginUpdate(pluginJAR, PluginUpdate.UNLOADED, bl));
        if (!jEdit.isMainThread() && !bl) {
            EditBus.send(new DynamicMenuChanged("plugins"));
        }
    }

    public static ActionContext getActionContext() {
        return actionContext;
    }

    public static void addActionSet(ActionSet actionSet) {
        actionContext.addActionSet(actionSet);
    }

    public static void removeActionSet(ActionSet actionSet) {
        actionContext.removeActionSet(actionSet);
    }

    public static ActionSet getBuiltInActionSet() {
        return builtInActionSet;
    }

    public static ActionSet[] getActionSets() {
        return (ActionSet[])actionContext.getActionSets();
    }

    public static EditAction getAction(String string) {
        return actionContext.getAction(string);
    }

    public static ActionSet getActionSetForAction(String string) {
        return actionContext.getActionSetForAction(string);
    }

    public static String[] getActionNames() {
        return actionContext.getActionNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadModes() {
        Object object;
        ModeProvider.instance.removeAll();
        if (jEditHome == null) {
            jEdit.loadModeCatalog("/modes/catalog", true);
        } else {
            jEdit.loadModeCatalog(MiscUtilities.constructPath(jEditHome, "modes", "catalog"), false);
        }
        if (settingsDirectory != null) {
            File file;
            object = new File(MiscUtilities.constructPath(settingsDirectory, "modes"));
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
            if (!(file = new File(MiscUtilities.constructPath(settingsDirectory, "modes", "catalog"))).exists()) {
                BufferedWriter bufferedWriter = null;
                try {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                    bufferedWriter.write(jEdit.getProperty("defaultCatalog"));
                    IOUtilities.closeQuietly((Closeable)bufferedWriter);
                }
                catch (IOException iOException) {
                    Log.log(9, jEdit.class, iOException);
                }
                finally {
                    IOUtilities.closeQuietly(bufferedWriter);
                }
            }
            jEdit.loadModeCatalog(file.getPath(), false);
        }
        object = buffersFirst;
        while (object != null) {
            ((Buffer)object).setMode();
            object = ((Buffer)object).next;
        }
    }

    public static Mode getMode(String string) {
        return ModeProvider.instance.getMode(string);
    }

    public static Mode[] getModes() {
        return ModeProvider.instance.getModes();
    }

    public static Buffer openFiles(View view, String string, String[] stringArray) {
        Buffer buffer = null;
        Buffer buffer2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null) continue;
            if (string2.startsWith("+line:") || string2.startsWith("+marker:")) {
                if (buffer2 == null) continue;
                jEdit.gotoMarker(view, buffer2, string2);
                continue;
            }
            buffer2 = jEdit.openFile((View)null, string, string2, false, null);
            if (buffer != null || buffer2 == null) continue;
            buffer = buffer2;
        }
        if (view != null && buffer != null) {
            view.setBuffer(buffer);
        }
        return buffer;
    }

    public static Buffer openFileAfterStartup(String string) {
        if (jEdit.isStartupDone()) {
            return jEdit.openFile(jEdit.getActiveView(), string);
        }
        additionalFiles.add(string);
        return null;
    }

    public static Buffer openFile(View view, String string) {
        return jEdit.openFile(view, null, string, false, new Hashtable<String, Object>());
    }

    public static Buffer openFile(View view, String string, String string2, boolean bl, Hashtable<String, Object> hashtable) {
        return jEdit.openFile(view == null ? null : view.getEditPane(), string, string2, bl, hashtable);
    }

    public static Buffer openFile(EditPane editPane, String string) {
        return jEdit.openFile(editPane, null, string, false, new Hashtable<String, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer openFile(EditPane editPane, String string, String string2, boolean bl, Hashtable<String, Object> hashtable) {
        Object object;
        PerspectiveManager.setPerspectiveDirty(true);
        if (editPane != null && string == null && editPane.getBuffer() != null) {
            string = editPane.getBuffer().getDirectory();
        }
        try {
            object = new URL(string2);
            if ("file".equals(((URL)object).getProtocol())) {
                string2 = URLDecoder.decode(((URL)object).getPath(), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = MiscUtilities.constructPath(string, string2);
        }
        catch (MalformedURLException malformedURLException) {
            string2 = MiscUtilities.constructPath(string, string2);
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        jEdit.composeBufferPropsFromHistory(hashtable, string2);
        Object object2 = editBusOrderingLock;
        synchronized (object2) {
            View view = editPane == null ? null : editPane.getView();
            Object object3 = bufferListLock;
            synchronized (object3) {
                Buffer buffer = jEdit.getBuffer(string2);
                if (buffer != null) {
                    if (editPane != null) {
                        editPane.setBuffer(buffer, true);
                    }
                    return buffer;
                }
                object = new Buffer(string2, bl, false, hashtable);
                if (!((Buffer)object).load(view, false)) {
                    return null;
                }
                jEdit.addBufferToList((Buffer)object);
                if (editPane != null) {
                    bufferSetManager.addBuffer(editPane, (Buffer)object);
                } else {
                    bufferSetManager.addBuffer(jEdit.getActiveView(), (Buffer)object);
                }
            }
            EditBus.send(new BufferUpdate((Buffer)object, view, BufferUpdate.CREATED));
        }
        if (editPane != null) {
            editPane.setBuffer((Buffer)object, true);
        }
        return object;
    }

    public static Buffer openTemporary(View view, String string, String string2, boolean bl) {
        return jEdit.openTemporary(view, string, string2, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer openTemporary(View view, String string, String string2, boolean bl, Hashtable<String, Object> hashtable) {
        if (view != null && string == null) {
            string = view.getBuffer().getDirectory();
        }
        if (MiscUtilities.isURL(string2) && "file".equals(MiscUtilities.getProtocolOfURL(string2))) {
            string2 = string2.substring(5);
        }
        string2 = MiscUtilities.constructPath(string, string2);
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        jEdit.composeBufferPropsFromHistory(hashtable, string2);
        Object object = bufferListLock;
        synchronized (object) {
            Buffer buffer = jEdit.getBuffer(string2);
            if (buffer != null) {
                return buffer;
            }
            buffer = new Buffer(string2, bl, true, hashtable);
            buffer.setBooleanProperty("encodingAutodetect", true);
            if (!buffer.load(view, false)) {
                return null;
            }
            return buffer;
        }
    }

    public static void commitTemporary(Buffer buffer) {
        if (!buffer.isTemporary()) {
            return;
        }
        PerspectiveManager.setPerspectiveDirty(true);
        jEdit.addBufferToList(buffer);
        buffer.commitTemporary();
        EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.CREATED));
        EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.LOAD_STARTED));
        EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.LOADED));
    }

    public static Buffer newFile(View view) {
        return jEdit.newFile(view == null ? null : view.getEditPane());
    }

    public static Buffer newFile(View view, String string) {
        EditPane editPane = null;
        if (view != null) {
            editPane = view.getEditPane();
        } else {
            View view2 = jEdit.getActiveView();
            if (view2 != null) {
                editPane = view2.getEditPane();
            }
        }
        return jEdit.newFile(editPane, string);
    }

    public static Buffer newFile(EditPane editPane) {
        String string;
        if (editPane != null && editPane.getBuffer() != null) {
            string = editPane.getBuffer().getDirectory();
            VFS vFS = VFSManager.getVFSForPath(string);
            if ((vFS.getCapabilities() & 2) == 0) {
                string = System.getProperty("user.home");
            }
        } else {
            string = null;
        }
        return jEdit.newFile(editPane, string);
    }

    public static Buffer newFile(EditPane editPane, String string) {
        if (editPane != null) {
            Buffer[] bufferArray;
            BufferSet bufferSet = editPane.getBufferSet();
            for (Buffer buffer : bufferArray = bufferSet.getAllBuffers()) {
                if (!buffer.isUntitled() || buffer.isDirty()) continue;
                if (!MiscUtilities.getParentOfPath(buffer.getPath()).equals(string)) {
                    int n = jEdit.getNextUntitledBufferId();
                    Buffer buffer2 = jEdit.openFile(editPane, string, "Untitled-" + n, true, null);
                    jEdit.closeBuffer(editPane, buffer);
                    return buffer2;
                }
                int n = buffer.getLength();
                if (n > 0) {
                    buffer.remove(0, n);
                }
                editPane.setBuffer(buffer);
                return buffer;
            }
        }
        int n = jEdit.getNextUntitledBufferId();
        return jEdit.openFile(editPane, string, "Untitled-" + n, true, null);
    }

    public static boolean closeBuffer(View view, Buffer buffer) {
        if (buffer.isPerformingIO()) {
            TaskManager.instance.waitForIoTasks();
            if (VFSManager.errorOccurred()) {
                return false;
            }
        }
        if (buffer.isDirty()) {
            Object[] objectArray = new Object[]{buffer.getName()};
            int n = GUIUtilities.confirm(view, "notsaved", objectArray, 1, 2);
            if (n == 0) {
                if (!buffer.save(view, null, true)) {
                    return false;
                }
                TaskManager.instance.waitForIoTasks();
                if (buffer.getBooleanProperty("BufferIORequest__error")) {
                    return false;
                }
            } else if (n != 1) {
                return false;
            }
        }
        jEdit._closeBuffer(view, buffer);
        return true;
    }

    public static void closeBuffer(EditPane editPane, Buffer buffer) {
        switch (bufferSetManager.getScope()) {
            case global: {
                jEdit.closeBuffer(editPane.getView(), buffer);
                break;
            }
            case view: {
                View view;
                BufferSet bufferSet;
                View[] viewArray = jEdit.getViews();
                int n = 0;
                View[] viewArray2 = viewArray;
                int n2 = viewArray2.length;
                for (int i = 0; i < n2 && ((bufferSet = (view = viewArray2[i]).getEditPane().getBufferSet()).indexOf(buffer) == -1 || ++n <= 1); ++i) {
                }
                if (n > 1) {
                    bufferSetManager.removeBuffer(editPane, buffer);
                    break;
                }
                jEdit.closeBuffer(editPane.getView(), buffer);
                break;
            }
            case editpane: {
                int n = bufferSetManager.countBufferSets(buffer);
                if (n < 2) {
                    jEdit.closeBuffer(editPane.getView(), buffer);
                    break;
                }
                bufferSetManager.removeBuffer(editPane, buffer);
            }
        }
    }

    public static void _closeBuffer(View view, Buffer buffer) {
        Object object;
        if (buffer.isClosed()) {
            return;
        }
        if (buffer.isTemporary()) {
            buffer.close();
            return;
        }
        PerspectiveManager.setPerspectiveDirty(true);
        if (!buffer.isNewFile()) {
            if (view != null) {
                view.getEditPane().saveCaretInfo();
            }
            int n = (object = (Integer)buffer.getProperty("Buffer__caret")) == null ? 0 : (Integer)object;
            BufferHistory.setEntry(buffer.getPath(), n, (Selection[])buffer.getProperty("Buffer__selection"), buffer.getStringProperty("encoding"), buffer.getMode().getName());
        }
        EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSING));
        object = buffer.getSymlinkPath();
        if ((VFSManager.getVFSForPath((String)object).getCapabilities() & 0x80) != 0) {
            object = ((String)object).toLowerCase();
        }
        bufferHash.remove(object);
        jEdit.removeBufferFromList(buffer);
        buffer.close();
        DisplayManager.bufferClosed(buffer);
        bufferSetManager.removeBuffer(buffer);
        EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSED));
        if (jEdit.getBooleanProperty("persistentMarkers")) {
            buffer.updateMarkersFile(view);
        }
    }

    public static boolean closeAllBuffers(View view) {
        return jEdit.closeAllBuffers(view, false);
    }

    public static boolean closeAllBuffers(View view, boolean bl) {
        boolean bl2;
        if (view != null) {
            view.getEditPane().saveCaretInfo();
        }
        boolean bl3 = false;
        boolean bl4 = !bl || !jEdit.getBooleanProperty("restore");
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.isDirty()) {
                bl3 = true;
                break;
            }
            buffer = buffer.next;
        }
        if (bl3 && !(bl2 = new CloseDialog(view).isOK())) {
            return false;
        }
        TaskManager.instance.waitForIoTasks();
        if (VFSManager.errorOccurred()) {
            return false;
        }
        buffer = buffersFirst;
        buffersLast = null;
        buffersFirst = null;
        bufferHash.clear();
        bufferCount = 0;
        while (buffer != null) {
            if (!buffer.isNewFile() && bl4) {
                Integer n = (Integer)buffer.getProperty("Buffer__caret");
                int n2 = n == null ? 0 : n;
                BufferHistory.setEntry(buffer.getPath(), n2, (Selection[])buffer.getProperty("Buffer__selection"), buffer.getStringProperty("encoding"), buffer.getMode().getName());
            }
            buffer.close();
            DisplayManager.bufferClosed(buffer);
            if (!bl) {
                bufferSetManager.removeBuffer(buffer);
                EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSED));
            }
            if (jEdit.getBooleanProperty("persistentMarkers")) {
                buffer.updateMarkersFile(view);
            }
            buffer = buffer.next;
        }
        PerspectiveManager.setPerspectiveDirty(true);
        return true;
    }

    public static void saveAllBuffers(View view) {
        jEdit.saveAllBuffers(view, jEdit.getBooleanProperty("confirmSaveAll"));
    }

    public static void saveAllBuffers(View view, boolean bl) {
        int n;
        if (bl && (n = GUIUtilities.confirm(view, "saveall", null, 0, 3)) != 0) {
            return;
        }
        Buffer buffer = view.getBuffer();
        Buffer buffer2 = buffersFirst;
        while (buffer2 != null) {
            if (buffer2.isDirty()) {
                if (buffer2.isNewFile()) {
                    view.setBuffer(buffer2);
                }
                buffer2.save(view, null, true, true);
            }
            buffer2 = buffer2.next;
        }
        view.setBuffer(buffer);
    }

    public static void reloadAllBuffers(View view, boolean bl) {
        int n;
        boolean bl2 = false;
        Buffer[] bufferArray = jEdit.getBuffers();
        for (n = 0; n < bufferArray.length && !bl2; ++n) {
            bl2 = !bufferArray[n].isUntitled() && bufferArray[n].isDirty();
        }
        if (bl && bl2 && (n = GUIUtilities.confirm(view, "reload-all", null, 0, 3)) != 0) {
            return;
        }
        jEdit.visit(new SaveCaretInfoVisitor());
        for (n = 0; n < bufferArray.length; ++n) {
            Buffer buffer = bufferArray[n];
            if (buffer.isUntitled()) continue;
            buffer.load(view, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer _getBuffer(String string) {
        if ((VFSManager.getVFSForPath(string).getCapabilities() & 0x80) != 0) {
            string = string.toLowerCase();
        }
        Object object = bufferListLock;
        synchronized (object) {
            return bufferHash.get(string);
        }
    }

    public static Buffer getBuffer(String string) {
        return jEdit._getBuffer(MiscUtilities.resolveSymlinks(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer[] getBuffers() {
        Object object = bufferListLock;
        synchronized (object) {
            Buffer[] bufferArray = new Buffer[bufferCount];
            Buffer buffer = buffersFirst;
            for (int i = 0; i < bufferCount; ++i) {
                bufferArray[i] = buffer;
                buffer = buffer.next;
            }
            return bufferArray;
        }
    }

    public static int getBufferCount() {
        return bufferCount;
    }

    public static Buffer getFirstBuffer() {
        return buffersFirst;
    }

    public static Buffer getLastBuffer() {
        return buffersLast;
    }

    public static void moveBuffer(EditPane editPane, int n, int n2) {
        bufferSetManager.moveBuffer(editPane, n, n2);
    }

    public static BufferSetManager getBufferSetManager() {
        return bufferSetManager;
    }

    public static JEditPropertyManager getPropertyManager() {
        return propertyManager;
    }

    public static void checkBufferStatus(View view) {
        jEdit.checkBufferStatus(view, false);
    }

    public static void checkBufferStatus(View view, boolean bl) {
        Log.log(1, jEdit.class, "checkBufferStatus for " + (bl ? "current buffer: " + view.getBuffer() : "all buffers"));
        boolean bl2 = jEdit.getBooleanProperty("autoReload");
        jEdit.visit(new SaveCaretInfoVisitor());
        Buffer buffer = buffersFirst;
        int[] nArray = new int[bufferCount];
        int n = 0;
        boolean bl3 = false;
        while (buffer != null) {
            if (bl && buffer != view.getBuffer()) {
                buffer = buffer.next;
                ++n;
                continue;
            }
            nArray[n] = buffer.checkFileStatus(view);
            switch (nArray[n]) {
                case 1: {
                    if (buffer.getAutoReload()) {
                        if (buffer.isDirty()) {
                            bl3 = true;
                        } else {
                            buffer.load(view, true);
                        }
                    } else {
                        bl2 = false;
                    }
                    if (!buffer.getAutoReloadDialog()) break;
                    bl3 = true;
                    break;
                }
                case 2: {
                    bl3 = true;
                }
            }
            buffer = buffer.next;
            ++n;
        }
        if (bl3) {
            new FilesChangedDialog(view, nArray, bl2);
        }
    }

    public static InputHandler getInputHandler() {
        return inputHandler;
    }

    public static View newView(View view) {
        return jEdit.newView(view, null, false);
    }

    public static View newView(View view, Buffer buffer) {
        return jEdit.newView(view, buffer, false);
    }

    public static View newView(View view, Buffer buffer, boolean bl) {
        View.ViewConfig viewConfig;
        if (view != null && bl == view.isPlainView()) {
            viewConfig = view.getViewConfig();
            viewConfig.x -= 20;
            viewConfig.y += 20;
        } else {
            viewConfig = new View.ViewConfig(bl);
        }
        return jEdit.newView(view, buffer, viewConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static View newView(View view, Buffer buffer, View.ViewConfig viewConfig) {
        if (jEdit.isStartupDone()) {
            PerspectiveManager.setPerspectiveDirty(true);
        }
        try {
            if (view != null) {
                view.showWaitCursor();
                view.getEditPane().saveCaretInfo();
            }
            View view2 = new View(buffer, viewConfig);
            jEdit.addViewToList(view2);
            EditBus.send(new ViewUpdate(view2, ViewUpdate.CREATED));
            view2.pack();
            view2.adjust(view, viewConfig);
            view2.setVisible(true);
            if (!viewConfig.plainView) {
                int n;
                List<Boolean> list = startupDone;
                synchronized (list) {
                    n = startupDone.size();
                    startupDone.add(false);
                }
                EventQueue.invokeLater(new DockingLayoutSetter(view2, viewConfig, n));
            }
            if (view2 == viewsFirst) {
                view2.getTextArea().requestFocus();
                if (settingsDirectory != null && jEdit.getBooleanProperty("firstTime")) {
                    new HelpViewer("welcome.html");
                } else if (jEdit.getBooleanProperty("tip.show")) {
                    new TipOfTheDay(view2);
                }
                jEdit.setBooleanProperty("firstTime", false);
            } else {
                GUIUtilities.requestFocus(view2, view2.getTextArea());
            }
            View view3 = view2;
            return view3;
        }
        finally {
            if (view != null) {
                view.hideWaitCursor();
            }
        }
    }

    public static void closeView(View view) {
        jEdit.closeView(view, true);
    }

    public static View[] getViews() {
        View[] viewArray = new View[viewCount];
        View view = viewsFirst;
        for (int i = 0; i < viewCount; ++i) {
            viewArray[i] = view;
            view = view.next;
        }
        return viewArray;
    }

    public static int getViewCount() {
        return viewCount;
    }

    public static View getFirstView() {
        return viewsFirst;
    }

    public static View getLastView() {
        return viewsLast;
    }

    public static View getActiveView() {
        if (activeView == null) {
            return viewsFirst;
        }
        return activeView;
    }

    public static void relocateSettings() {
        String string = MiscUtilities.constructPath(System.getProperty("user.home"), ".jedit");
        File file = new File(string);
        File file2 = new File(settingsDirectory);
        if (file.exists() && !file2.exists()) {
            Log.log(5, jEdit.class, "Old settings directory found (HOME/.jedit). Moving to new location (" + file2 + ')');
            try {
                file.renameTo(file2);
            }
            catch (SecurityException securityException) {
                Log.log(9, jEdit.class, securityException);
            }
        }
    }

    public static boolean isStartupDone() {
        return !startupDone.contains(false);
    }

    public static boolean isMainThread() {
        return Thread.currentThread() == mainThread;
    }

    public static boolean isBackgroundModeEnabled() {
        return background;
    }

    public static void showMemoryDialog(View view) {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        System.gc();
        long l2 = runtime.freeMemory();
        long l3 = runtime.totalMemory();
        long l4 = l3 - l2;
        int n = (int)(l3 / 1024L);
        int n2 = (int)(l4 / 1024L);
        JProgressBar jProgressBar = new JProgressBar(0, n);
        jProgressBar.setValue(n2);
        jProgressBar.setStringPainted(true);
        jProgressBar.setString(jEdit.getProperty("memory-status.use", new Object[]{n2, n}));
        Object[] objectArray = new Object[]{jEdit.getProperty("memory-status.gc", new Object[]{(l - l4) / 1024L}), Box.createVerticalStrut(12), jProgressBar, Box.createVerticalStrut(6)};
        JOptionPane.showMessageDialog(view, objectArray, jEdit.getProperty("memory-status.title"), 1);
    }

    public static String getJEditHome() {
        return jEditHome;
    }

    public static String getSettingsDirectory() {
        return settingsDirectory;
    }

    public static String getJARCacheDirectory() {
        return jarCacheDirectory;
    }

    public static void backupSettingsFile(File file) {
        if (settingsDirectory == null || !file.exists()) {
            return;
        }
        String string = MiscUtilities.constructPath(settingsDirectory, "settings-backup");
        File file2 = new File(string);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        MiscUtilities.saveBackup(file, 5, null, "~", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSettings() {
        block7: {
            File file;
            File file2;
            block6: {
                if (settingsDirectory == null) {
                    return;
                }
                Abbrevs.save();
                keymapManager.getKeymap().save();
                FavoritesVFS.saveFavorites();
                HistoryModel.saveHistory();
                Registers.saveRegisters();
                SearchAndReplace.save();
                BufferHistory.save();
                KillRing.getInstance().save();
                file2 = new File(MiscUtilities.constructPath(settingsDirectory, "#properties#save#"));
                file = new File(MiscUtilities.constructPath(settingsDirectory, "properties"));
                if (!file.exists() || file.lastModified() == propsModTime) break block6;
                Log.log(7, jEdit.class, file + " changed" + " on disk; will not save user properties");
                break block7;
            }
            jEdit.backupSettingsFile(file);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file2);
                propMgr.saveUserProps(fileOutputStream);
            }
            catch (IOException iOException) {
                try {
                    Log.log(9, jEdit.class, iOException);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(fileOutputStream);
                    throw throwable;
                }
                IOUtilities.closeQuietly((Closeable)fileOutputStream);
            }
            IOUtilities.closeQuietly((Closeable)fileOutputStream);
            file.delete();
            if (!file2.renameTo(file)) {
                Log.log(9, jEdit.class, "Failed to rename \"" + file2 + "\" to the user properties file \"" + file + "\".");
            }
            propsModTime = file.lastModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(View view, boolean bl) {
        if (view == null) {
            view = activeView;
        }
        TaskManager.instance.waitForIoTasks();
        EditorExitRequested editorExitRequested = new EditorExitRequested(view);
        EditBus.send(editorExitRequested);
        if (editorExitRequested.hasBeenExitCancelled()) {
            Log.log(3, jEdit.class, "Exit has been cancelled");
            return;
        }
        bl |= !background;
        PerspectiveManager.savePerspective(false);
        try {
            PerspectiveManager.setPerspectiveEnabled(false);
            if (!jEdit.closeAllBuffers(view, bl)) {
                return;
            }
        }
        finally {
            PerspectiveManager.setPerspectiveEnabled(true);
        }
        if (!bl) {
            view = viewsFirst;
            while (view != null) {
                jEdit.closeView(view, false);
                view = view.next;
            }
            jEdit.saveSettings();
        } else {
            EditBus.send(new EditorExiting(null));
            view = viewsFirst;
            while (view != null) {
                jEdit.closeView(view, false);
                view = view.next;
            }
            Autosave.stop();
            if (server != null) {
                server.stopServer();
            }
            PluginJAR[] pluginJARArray = jEdit.getPluginJARs();
            for (int i = 0; i < pluginJARArray.length; ++i) {
                jEdit.removePluginJAR(pluginJARArray[i], true);
            }
            jEdit.saveSettings();
            Log.closeStream();
            System.exit(0);
        }
    }

    public static EditServer getEditServer() {
        return server;
    }

    public static void visit(JEditVisitor jEditVisitor) {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            jEditVisitor.visit(view);
            view.visit(jEditVisitor);
        }
    }

    public static String getRegisterStatusPrompt(String string) {
        String string2 = Registers.getRegisterNameString();
        return jEdit.getProperty("view.status." + string, new String[]{string2 == null ? jEdit.getProperty("view.status.no-registers") : string2});
    }

    public static KeymapManager getKeymapManager() {
        return keymapManager;
    }

    private static void logTime(String string) {
        long l = System.currentTimeMillis();
        Log.log(1, jEdit.class, string + ':' + (l - startupTime) + " ms");
    }

    static void updatePosition(String string, Buffer buffer) {
        if ((VFSManager.getVFSForPath(string).getCapabilities() & 0x80) != 0) {
            string = string.toLowerCase();
        }
        bufferHash.remove(string);
        String string2 = buffer.getSymlinkPath();
        if ((VFSManager.getVFSForPath(string2).getCapabilities() & 0x80) != 0) {
            string2 = string2.toLowerCase();
        }
        bufferHash.put(string2, buffer);
        if (sortBuffers) {
            jEdit.removeBufferFromList(buffer);
            jEdit.addBufferToList(buffer);
        }
    }

    static void loadMode(Mode mode) {
        final String string = (String)mode.getProperty("file");
        XModeHandler xModeHandler = new XModeHandler(mode.getName()){

            @Override
            public void error(String string3, Object object) {
                String string2;
                Object object2 = "<unknown>";
                if (object == null) {
                    string2 = jEdit.getProperty("xmode-error." + string3);
                } else {
                    string2 = jEdit.getProperty("xmode-error." + string3, new String[]{object.toString()});
                    if (object instanceof Throwable) {
                        Log.log(9, this, object);
                    }
                    if (object instanceof SAXParseException) {
                        object2 = ((SAXParseException)object).getLineNumber();
                    }
                }
                Object[] objectArray = new Object[]{string, object2, null, string2};
                GUIUtilities.error(null, "xmode-error", objectArray);
            }

            @Override
            public TokenMarker getTokenMarker(String string2) {
                Mode mode = jEdit.getMode(string2);
                if (mode == null) {
                    return null;
                }
                return mode.getTokenMarker();
            }
        };
        ModeProvider.instance.loadMode(mode, xModeHandler);
    }

    static void addPluginProps(Properties properties) {
        propMgr.addPluginProps(properties);
    }

    static void removePluginProps(Properties properties) {
        propMgr.removePluginProps(properties);
    }

    static void addPluginLocalizationProps(Properties properties) {
        propMgr.addPluginLocalizationProps(properties);
    }

    static void removePluginLocalizationProps(Properties properties) {
        propMgr.removePluginLocalizationProps(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pluginError(String string, String string2, Object[] objectArray) {
        Object object = pluginErrorLock;
        synchronized (object) {
            if (pluginErrors == null) {
                pluginErrors = new Vector();
            }
            ErrorListDialog.ErrorEntry errorEntry = new ErrorListDialog.ErrorEntry(string, string2, objectArray);
            for (ErrorListDialog.ErrorEntry errorEntry2 : pluginErrors) {
                if (!errorEntry2.equals(errorEntry)) continue;
                return;
            }
            pluginErrors.addElement(errorEntry);
            if (jEdit.isStartupDone()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jEdit.showPluginErrorDialog();
                    }
                });
            }
        }
    }

    static void setActiveView(View view) {
        activeView = view;
    }

    public static View getActiveViewInternal() {
        return activeView;
    }

    private jEdit() {
    }

    private static void usage() {
        System.out.println("Usage: jedit [<options>] [<files>]");
        System.out.println("\t<file> +marker:<marker>: Positions caret at marker <marker>");
        System.out.println("\t<file> +line:<line>: Positions caret at line number <line>");
        System.out.println("\t<file> +line:<line>,<column>: Positions caret at line number <line> and column number <column>");
        System.out.println("\t--: End of options");
        System.out.println("\t-background: Run in background mode");
        System.out.println("\t-nobackground: Disable background mode (default)");
        System.out.println("\t-gui: Only if running in background mode; open initial view (default)");
        System.out.println("\t-nogui: Only if running in background mode; don't open initial view");
        System.out.println("\t-log=<level>: Log messages with level equal to or higher than this to");
        System.out.println("\t standard error. <level> must be between 1 and 9. Default is 7.");
        System.out.println("\t-newplainview: Client instance opens a new plain view");
        System.out.println("\t-newview: Client instance opens a new view (default)");
        System.out.println("\t-plugins: Load plugins (default)");
        System.out.println("\t-noplugins: Don't load any plugins");
        System.out.println("\t-restore: Restore previously open files (default)");
        System.out.println("\t-norestore: Don't restore previously open files");
        System.out.println("\t-reuseview: Client instance reuses existing view");
        System.out.println("\t-quit: Quit a running instance");
        System.out.println("\t-run=<script>: Run the specified BeanShell script");
        System.out.println("\t-server: Read/write server info from/to $HOME/.jedit/server (default)");
        System.out.println("\t-server=<name>: Read/write server info from/to $HOME/.jedit/<name>");
        System.out.println("\t-noserver: Don't start edit server");
        System.out.println("\t-settings=<path>: Load user-specific settings from <path>");
        System.out.println("\t-nosettings: Don't load user-specific settings");
        System.out.println("\t-nosplash: Don't show splash screen");
        System.out.println("\t-startupscripts: Run startup scripts (default)");
        System.out.println("\t-nostartupscripts: Don't run startup scripts");
        System.out.println("\t-usage: Print this message and exit");
        System.out.println("\t-version: Print jEdit version and exit");
        System.out.println("\t-wait: Wait until the user closes the specified buffer in the server");
        System.out.println("\t instance. Does nothing if passed to the initial jEdit instance.");
        System.out.println();
        System.out.println("Report bugs to http://sourceforge.net/tracker/?group_id=588&atid=100588");
    }

    private static void version() {
        System.out.println("jEdit " + jEdit.getVersion());
    }

    private static String makeServerScript(boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = System.getProperty("user.dir");
        stringBuilder.append("parent = \"");
        stringBuilder.append(StandardUtilities.charsToEscapes(string2));
        stringBuilder.append("\";\n");
        stringBuilder.append("args = new String[");
        stringBuilder.append(stringArray.length);
        stringBuilder.append("];\n");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append("args[");
            stringBuilder.append(i);
            stringBuilder.append("] = ");
            if (stringArray[i] == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append('\"');
                stringBuilder.append(StandardUtilities.charsToEscapes(stringArray[i]));
                stringBuilder.append('\"');
            }
            stringBuilder.append(";\n");
        }
        stringBuilder.append("view = jEdit.getLastView();\n");
        stringBuilder.append("buffer = EditServer.handleClient(");
        stringBuilder.append(bl2).append(',').append(bl3).append(',').append(bl4);
        stringBuilder.append(",parent,args);\n");
        stringBuilder.append("if(buffer != null && ").append(bl).append(") {\n");
        stringBuilder.append("\tbuffer.setWaitSocket(socket);\n");
        stringBuilder.append("\tdoNotCloseSocket = true;\n");
        stringBuilder.append("}\n");
        stringBuilder.append("if(view != jEdit.getLastView() && ").append(bl).append(") {\n");
        stringBuilder.append("\tjEdit.getLastView().setWaitSocket(socket);\n");
        stringBuilder.append("\tdoNotCloseSocket = true;\n");
        stringBuilder.append("}\n");
        stringBuilder.append("if(doNotCloseSocket == void)\n");
        stringBuilder.append("\tsocket.close();\n");
        if (string != null) {
            string = MiscUtilities.constructPath(string2, string);
            stringBuilder.append("BeanShell.runScript(view,\"").append(StandardUtilities.charsToEscapes(string)).append("\",null,this.namespace);\n");
        }
        return stringBuilder.toString();
    }

    private static void initMisc() {
        ModeProvider.instance = new ModeProvider(){

            @Override
            protected void error(String string, Throwable throwable) {
                Log.log(9, this, throwable);
                if (throwable instanceof SAXParseException) {
                    String string2 = throwable.getMessage();
                    int n = ((SAXParseException)throwable).getLineNumber();
                    int n2 = ((SAXParseException)throwable).getColumnNumber();
                    Object[] objectArray = new Object[]{string, n, n2, string2};
                    GUIUtilities.error(null, "xmode-error", objectArray);
                }
            }
        };
        jars = new Vector();
        FoldHandler.foldHandlerProvider = new ServiceManager.ServiceFoldHandlerProvider();
        actionContext = new ActionContext(){

            @Override
            public void invokeAction(EventObject eventObject, EditAction editAction) {
                ActionBar actionBar;
                View view = GUIUtilities.getView((Component)eventObject.getSource());
                boolean bl = view.getActionBar() == null || !view.getActionBar().isShowing() ? false : view.getActionBar().isVisible();
                view.getInputHandler().invokeAction(editAction);
                if (bl && (actionBar = view.getActionBar()) != null) {
                    view.removeToolBar(actionBar);
                }
            }
        };
        bufferHash = new HashMap<String, Buffer>();
        File file = null;
        if (settingsDirectory != null) {
            file = new File(settingsDirectory, "keymaps");
        }
        inputHandler = new DefaultInputHandler(null);
        System.getProperties().put("java.protocol.handler.pkgs", "org.gjt.sp.jedit.proto|" + System.getProperty("java.protocol.handler.pkgs", ""));
        String string = "jEdit/" + jEdit.getVersion() + " (Java " + System.getProperty("java.version") + ". " + System.getProperty("java.vendor") + "; " + System.getProperty("os.arch") + ')';
        System.getProperties().put("http.agent", string);
        jEditHome = System.getProperty("jedit.home");
        if (jEditHome == null) {
            int n;
            String string2 = System.getProperty("java.class.path");
            int n2 = string2.lastIndexOf(File.pathSeparator, n = string2.toLowerCase().indexOf("jedit.jar")) + 1;
            if (n2 == n) {
                jEditHome = System.getProperty("user.dir");
            } else if (n > n2) {
                jEditHome = string2.substring(n2, n - 1);
            } else {
                jEditHome = System.getProperty("user.dir");
                Log.log(7, jEdit.class, "jedit.jar not in class path!");
                Log.log(7, jEdit.class, "Assuming jEdit is installed in " + jEditHome + '.');
                Log.log(7, jEdit.class, "Override with jedit.home system property.");
            }
        }
        jEditHome = MiscUtilities.resolveSymlinks(jEditHome);
        Log.log(3, jEdit.class, "jEdit home directory is " + jEditHome);
        keymapManager = new KeymapManagerImpl(propertyManager, new File(jEditHome, "keymaps"), file);
        if (settingsDirectory != null) {
            jarCacheDirectory = MiscUtilities.constructPath(settingsDirectory, "jars-cache");
            new File(jarCacheDirectory).mkdirs();
        }
        EditBus.addToBus(new SettingsReloader());
        Thread.currentThread().setContextClassLoader(new JARClassLoader());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(new JARClassLoader());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Reader getResourceAsUTF8Text(String string) throws IOException {
        InputStream inputStream = jEdit.class.getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        Reader reader = null;
        try {
            CharsetEncoding charsetEncoding = new CharsetEncoding("UTF-8");
            reader = charsetEncoding.getTextReader(inputStream);
        }
        finally {
            if (reader == null) {
                inputStream.close();
            }
        }
        return reader;
    }

    private static void initSystemProperties() {
        propMgr = new PropertyManager();
        try {
            propMgr.loadSystemProps(jEdit.getResourceAsUTF8Text("/org/gjt/sp/jedit/jedit.props"));
            propMgr.loadSystemProps(jEdit.getResourceAsUTF8Text("/org/gjt/sp/jedit/jedit_gui.props"));
            propMgr.loadSystemProps(jEdit.getResourceAsUTF8Text("/org/jedit/localization/jedit_en.props"));
        }
        catch (Exception exception) {
            Log.log(9, jEdit.class, "Error while loading system properties!");
            Log.log(9, jEdit.class, "One of the following property files could not be loaded:\n- jedit.props\n- jedit_gui.props\n- jedit_en.props\njedit.jar is probably corrupt.");
            Log.log(9, jEdit.class, exception);
            System.exit(1);
        }
    }

    private static void initSiteProperties() {
        String string = MiscUtilities.constructPath(jEditHome, "properties");
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        Arrays.sort(stringArray, new StandardUtilities.StringCompare(true));
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.toLowerCase().endsWith(".props")) continue;
            try {
                String string3 = MiscUtilities.constructPath(string, string2);
                Log.log(1, jEdit.class, "Loading site snippet: " + string3);
                propMgr.loadSiteProps(new FileInputStream(new File(string3)));
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.log(1, jEdit.class, fileNotFoundException);
                continue;
            }
            catch (IOException iOException) {
                Log.log(9, jEdit.class, "Cannot load site snippet " + string2);
                Log.log(9, jEdit.class, iOException);
            }
        }
    }

    private static void initResources() {
        builtInActionSet = new ActionSet(null, null, null, jEdit.class.getResource("actions.xml"));
        builtInActionSet.setLabel(jEdit.getProperty("action-set.jEdit"));
        builtInActionSet.load();
        actionContext.addActionSet(builtInActionSet);
        DockableWindowFactory.getInstance().loadDockableWindows(null, jEdit.class.getResource("dockables.xml"), null);
        ServiceManager.loadServices(null, jEdit.class.getResource("services.xml"), null);
    }

    private static void initPlugins() {
        Object object;
        if (jEditHome != null) {
            jEdit.addPluginJARsFromDirectory(MiscUtilities.constructPath(jEditHome, "jars"));
        }
        if (settingsDirectory != null) {
            object = new File(settingsDirectory, "jars");
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
            jEdit.addPluginJARsFromDirectory(((File)object).getPath());
        }
        object = jEdit.getPluginJARs();
        for (int i = 0; i < ((PluginJAR[])object).length; ++i) {
            ((PluginJAR)object[i]).checkDependencies();
        }
    }

    private static void initUserProperties() {
        if (settingsDirectory != null) {
            File file = new File(MiscUtilities.constructPath(settingsDirectory, "properties"));
            propsModTime = file.lastModified();
            try {
                propMgr.loadUserProps(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {
                Log.log(9, jEdit.class, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLocalizationProperties() {
        String string = jEdit.getCurrentLanguage();
        if ("en".equals(string)) {
            return;
        }
        Reader reader = null;
        try {
            reader = jEdit.getResourceAsUTF8Text("/org/jedit/localization/jedit_" + string + ".props");
            propMgr.loadLocalizationProps(reader);
            IOUtilities.closeQuietly((Closeable)reader);
        }
        catch (IOException iOException) {
            if (jEdit.getBooleanProperty("lang.usedefaultlocale")) {
                Log.log(9, jEdit.class, "Unable to load language", iOException);
            }
        }
        finally {
            IOUtilities.closeQuietly(reader);
        }
    }

    private static String fontStyleToString(int n) {
        if (n == 0) {
            return "PLAIN";
        }
        if (n == 1) {
            return "BOLD";
        }
        if (n == 2) {
            return "ITALIC";
        }
        if (n == 3) {
            return "BOLDITALIC";
        }
        throw new RuntimeException("Invalid style: " + n);
    }

    private static String fontToString(Font font) {
        return font.getFamily() + '-' + jEdit.fontStyleToString(font.getStyle()) + '-' + font.getSize();
    }

    private static void initPLAF() {
        Object object;
        Object object2;
        String string = jEdit.getProperty("lookAndFeel");
        String string2 = null;
        String string3 = null;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null) {
            string2 = lookAndFeel.getClass().getName();
        }
        if (jEdit.isStartupDone() && jEdit.getPLAFClassName(string).equals(string2)) {
            return;
        }
        Font font = jEdit.getFontProperty("metal.primary.font");
        if (font != null) {
            object2 = jEdit.fontToString(font);
            System.getProperties().put("swing.plaf.metal.controlFont", object2);
            System.getProperties().put("swing.plaf.metal.menuFont", object2);
        }
        if ((object2 = jEdit.getFontProperty("metal.secondary.font")) != null) {
            object = jEdit.fontToString((Font)object2);
            System.getProperties().put("swing.plaf.metal.systemFont", object);
            System.getProperties().put("swing.plaf.metal.userFont", object);
        }
        KeyboardFocusManager.setCurrentKeyboardFocusManager(new MyFocusManager());
        try {
            UIManager.setLookAndFeel(jEdit.getPLAFClassName(string));
        }
        catch (Exception exception) {
            Log.log(9, jEdit.class, exception);
        }
        object = UIManager.getLookAndFeel();
        if (object != null) {
            string3 = object.getClass().getName();
        }
        Log.log(1, jEdit.class, "initPLAF " + (EventQueue.isDispatchThread() ? "edt" : "non-edt") + " old=" + string2 + " requested=" + string + " new=" + string3);
        if (string == null || !string.equals(string3)) {
            Log.log(7, jEdit.class, "initPLAF failed to set required l&f");
        }
        UIDefaults uIDefaults = UIManager.getDefaults();
        if (jEdit.getBooleanProperty("textColors")) {
            ColorUIResource colorUIResource = new ColorUIResource(jEdit.getColorProperty("view.bgColor"));
            Window[] windowArray = new ColorUIResource(jEdit.getColorProperty("view.fgColor"));
            ColorUIResource colorUIResource2 = new ColorUIResource(jEdit.getColorProperty("view.caretColor"));
            ColorUIResource colorUIResource3 = new ColorUIResource(jEdit.getColorProperty("view.selectionColor"));
            String[] stringArray = new String[]{"PasswordField", "TextField", "TextArea", "List", "Table"};
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                uIDefaults.put(string4 + ".foreground", windowArray);
                uIDefaults.put(string4 + ".background", colorUIResource);
                uIDefaults.put(string4 + ".disabledForeground", windowArray);
                uIDefaults.put(string4 + ".disabledBackground", colorUIResource);
                uIDefaults.put(string4 + ".caretForeground", colorUIResource2);
                uIDefaults.put(string4 + ".selectionForeground", windowArray);
                uIDefaults.put(string4 + ".selectionBackground", colorUIResource3);
            }
            uIDefaults.put("ComboBox.foreground", windowArray);
            uIDefaults.put("ComboBox.background", colorUIResource);
            uIDefaults.put("ComboBox.disabledForeground", windowArray);
            uIDefaults.put("ComboBox.disabledBackground", colorUIResource);
            uIDefaults.put("ComboBox.selectedForeground", windowArray);
            uIDefaults.put("ComboBox.selectedBackground", colorUIResource3);
            uIDefaults.put("Tree.background", colorUIResource);
            uIDefaults.put("Tree.foreground", windowArray);
            uIDefaults.put("Tree.textBackground", colorUIResource);
            uIDefaults.put("Tree.textForeground", windowArray);
            uIDefaults.put("Tree.selectionForeground", windowArray);
            uIDefaults.put("Tree.selectionBackground", colorUIResource3);
        }
        uIDefaults.remove("SplitPane.border");
        uIDefaults.remove("SplitPaneDivider.border");
        JFrame.setDefaultLookAndFeelDecorated(jEdit.getBooleanProperty("decorate.frames"));
        JDialog.setDefaultLookAndFeelDecorated(jEdit.getBooleanProperty("decorate.dialogs"));
        if (jEdit.isStartupDone()) {
            int n = 0;
            for (Window window : Window.getWindows()) {
                try {
                    SwingUtilities.updateComponentTreeUI(window);
                }
                catch (Exception exception) {
                    Log.log(9, jEdit.class, "Window " + n + ": " + window, exception);
                    break;
                }
                ++n;
            }
        }
    }

    @Nonnull
    private static String getPLAFClassName(@Nullable String string) {
        if (string != null && string.length() != 0) {
            return string;
        }
        if (OperatingSystem.isMacOS()) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static int getNextUntitledBufferId() {
        int n = 0;
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.getName().startsWith("Untitled-")) {
                try {
                    n = Math.max(n, Integer.parseInt(buffer.getName().substring(9)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buffer = buffer.next;
        }
        return n + 1;
    }

    private static void runStartupScripts(File file) {
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        Arrays.sort(fileArray, new StandardUtilities.StringCompare(true));
        String string = jEdit.getProperty("buffer.encoding");
        jEdit.setProperty("buffer.encoding", "UTF-8");
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            Macros.Handler handler = Macros.getHandlerForPathName(file2.getPath());
            if (handler == null) continue;
            try {
                Macros.Macro macro = handler.createMacro(file2.getName(), file2.getPath());
                handler.runMacro(null, macro, false);
                continue;
            }
            catch (Exception exception) {
                Log.log(9, jEdit.class, exception);
            }
        }
        jEdit.setProperty("buffer.encoding", string);
    }

    private static void initProxy() {
        String string;
        boolean bl = jEdit.getBooleanProperty("firewall.socks.enabled");
        if (!bl) {
            Log.log(1, jEdit.class, "SOCKS proxy disabled");
            System.getProperties().remove("socksProxyHost");
            System.getProperties().remove("socksProxyPort");
        } else {
            String string2 = jEdit.getProperty("firewall.socks.host");
            if (string2 != null) {
                System.setProperty("socksProxyHost", string2);
                Log.log(1, jEdit.class, "SOCKS proxy enabled: " + string2);
            }
            if ((string = jEdit.getProperty("firewall.socks.port")) != null) {
                System.setProperty("socksProxyPort", string);
            }
        }
        boolean bl2 = jEdit.getBooleanProperty("firewall.enabled");
        if (!bl2) {
            Log.log(1, jEdit.class, "HTTP proxy disabled");
            System.getProperties().remove("proxySet");
            System.getProperties().remove("proxyHost");
            System.getProperties().remove("proxyPort");
            System.getProperties().remove("http.proxyHost");
            System.getProperties().remove("http.proxyPort");
            System.getProperties().remove("http.nonProxyHosts");
            Authenticator.setDefault(null);
        } else {
            String string3;
            string = jEdit.getProperty("firewall.host");
            if (string == null) {
                return;
            }
            System.setProperty("http.proxyHost", string);
            Log.log(1, jEdit.class, "HTTP proxy enabled: " + string);
            String string4 = jEdit.getProperty("firewall.port");
            if (string4 != null) {
                System.setProperty("http.proxyPort", string4);
            }
            if ((string3 = jEdit.getProperty("firewall.nonProxyHosts")) != null) {
                System.setProperty("http.nonProxyHosts", string3);
            }
            String string5 = jEdit.getProperty("firewall.user");
            String string6 = jEdit.getProperty("firewall.password");
            if (string6 == null) {
                string6 = "";
            }
            if (string5 == null || string5.length() == 0) {
                Log.log(1, jEdit.class, "HTTP proxy without user");
                Authenticator.setDefault(new FirewallAuthenticator(null));
            } else {
                Log.log(1, jEdit.class, "HTTP proxy user: " + string5);
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(string5, string6.toCharArray());
                Authenticator.setDefault(new FirewallAuthenticator(passwordAuthentication));
            }
        }
    }

    private static void finishStartup(final boolean bl, final boolean bl2, final boolean bl3, final String string, final String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean bl4;
                int n = jEdit.getBufferCount();
                boolean bl22 = bl4 = bl2 && jEdit.getBooleanProperty("restore") && (n == 0 || jEdit.getBooleanProperty("restore.cli"));
                if (bl || n != 0) {
                    Buffer buffer;
                    View view = bl3 ? jEdit.newView(null, null, true) : PerspectiveManager.loadPerspective(bl4);
                    if (view == null) {
                        view = jEdit.newView(null, null);
                    }
                    if (!additionalFiles.isEmpty()) {
                        Object[] objectArray = new String[additionalFiles.size() + stringArray.length];
                        additionalFiles.copyInto(objectArray);
                        System.arraycopy(stringArray, 0, objectArray, additionalFiles.size(), stringArray.length);
                        buffer = jEdit.openFiles(null, string, (String[])objectArray);
                    } else {
                        buffer = jEdit.openFiles(null, string, stringArray);
                    }
                    if (buffer != null) {
                        view.setBuffer(buffer);
                    }
                    view.toFront();
                } else {
                    jEdit.openFiles(null, string, stringArray);
                }
                EditBus.send(new EditorStarted(null));
                VFSManager.start();
                if (server != null) {
                    server.start();
                }
                GUIUtilities.hideSplashScreen();
                Log.log(3, jEdit.class, "Startup complete: " + (System.currentTimeMillis() - startupTime) + " ms");
                if (pluginErrors != null) {
                    jEdit.showPluginErrorDialog();
                }
                startupDone.set(0, true);
                Toolkit.getDefaultToolkit();
            }
        });
    }

    private static void showPluginErrorDialog() {
        if (pluginErrors == null) {
            return;
        }
        String string = jEdit.getProperty("plugin-error.caption" + (pluginErrors.size() == 1 ? "-1" : ""));
        JFrame jFrame = PluginManager.getInstance() == null ? viewsFirst : PluginManager.getInstance();
        new ErrorListDialog(jFrame, jEdit.getProperty("plugin-error.title"), string, pluginErrors, true);
        pluginErrors = null;
    }

    private static void getNotLoadedPluginJARs(Collection<String> collection, String string, String[] stringArray) {
        block0: for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.toLowerCase().endsWith(".jar")) continue;
            String string3 = MiscUtilities.constructPath(string, string2);
            for (int j = 0; j < jars.size(); ++j) {
                PluginJAR pluginJAR = jars.elementAt(j);
                String string4 = pluginJAR.getPath();
                if (string3.equals(string4) || string2.equals(MiscUtilities.getFileName(string4)) && !new File(string4).exists()) continue block0;
            }
            collection.add(string3);
        }
    }

    private static void gotoMarker(final View view, final Buffer buffer, final String string) {
        AwtRunnableQueue.INSTANCE.runAfterIoTasks(new Runnable(){

            @Override
            public void run() {
                int n;
                if (string.startsWith("+line:")) {
                    try {
                        int n2;
                        int n3;
                        String string2 = string.substring(6);
                        String[] stringArray = string2.split(",");
                        if (stringArray.length > 1) {
                            n3 = Integer.parseInt(stringArray[0]);
                            n2 = Integer.parseInt(stringArray[1]);
                        } else {
                            n3 = Integer.parseInt(string.substring(6));
                            n2 = 1;
                        }
                        n = buffer.getLineStartOffset(n3 - 1) + (n2 - 1);
                    }
                    catch (Exception exception) {
                        return;
                    }
                } else if (string.startsWith("+marker:")) {
                    if (string.length() != 9) {
                        return;
                    }
                    Marker marker = buffer.getMarker(string.charAt(8));
                    if (marker == null) {
                        return;
                    }
                    n = marker.getPosition();
                } else {
                    throw new InternalError();
                }
                if (view != null && view.getBuffer() == buffer) {
                    view.getTextArea().setCaretPosition(n);
                    buffer.setIntegerProperty("Buffer__caret", n);
                    buffer.setBooleanProperty("Buffer__caretPositioned", true);
                } else {
                    buffer.setIntegerProperty("Buffer__caret", n);
                    buffer.setBooleanProperty("Buffer__caretPositioned", true);
                    buffer.unsetProperty("Buffer__scrollVert");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addBufferToList(Buffer buffer) {
        Object object = bufferListLock;
        synchronized (object) {
            String string = buffer.getSymlinkPath();
            if ((VFSManager.getVFSForPath(string).getCapabilities() & 0x80) != 0) {
                string = string.toLowerCase();
            }
            ++bufferCount;
            bufferHash.put(string, buffer);
            if (buffersFirst == null) {
                buffersFirst = buffersLast = buffer;
                return;
            }
            if (sortBuffers) {
                String string2;
                String string3;
                if (sortByName) {
                    string3 = buffer.getName();
                    string2 = buffer.getDirectory();
                } else {
                    string3 = buffer.getDirectory();
                    string2 = buffer.getName();
                }
                Buffer buffer2 = buffersFirst;
                while (buffer2 != null) {
                    String string4;
                    String string5;
                    if (sortByName) {
                        string5 = buffer2.getName();
                        string4 = buffer2.getDirectory();
                    } else {
                        string5 = buffer2.getDirectory();
                        string4 = buffer2.getName();
                    }
                    int n = StandardUtilities.compareStrings(string3, string5, true);
                    if (n < 0 || n == 0 && StandardUtilities.compareStrings(string2, string4, true) < 0) {
                        buffer.next = buffer2;
                        buffer.prev = buffer2.prev;
                        buffer2.prev = buffer;
                        if (buffer2 != buffersFirst) {
                            buffer.prev.next = buffer;
                        } else {
                            buffersFirst = buffer;
                        }
                        return;
                    }
                    buffer2 = buffer2.next;
                }
            }
            buffer.prev = buffersLast;
            buffer.next = null;
            jEdit.buffersLast.next = buffer;
            buffersLast = buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeBufferFromList(Buffer buffer) {
        Object object = bufferListLock;
        synchronized (object) {
            --bufferCount;
            String string = buffer.getPath();
            if (OperatingSystem.isCaseInsensitiveFS()) {
                string = string.toLowerCase();
            }
            bufferHash.remove(string);
            if (buffer == buffersFirst && buffer == buffersLast) {
                buffersLast = null;
                buffersFirst = null;
                return;
            }
            if (buffer == buffersFirst) {
                buffersFirst = buffer.next;
                buffer.next.prev = null;
            } else if (buffer.prev != null) {
                buffer.prev.next = buffer.next;
            }
            if (buffer == buffersLast) {
                buffersLast = jEdit.buffersLast.prev;
                buffer.prev.next = null;
            } else if (buffer.next != null) {
                buffer.next.prev = buffer.prev;
            }
            buffer.prev = null;
            buffer.next = null;
        }
    }

    private static void addViewToList(View view) {
        ++viewCount;
        if (viewsFirst == null) {
            viewsFirst = viewsLast = view;
        } else {
            view.prev = viewsLast;
            jEdit.viewsLast.next = view;
            viewsLast = view;
        }
    }

    private static void removeViewFromList(View view) {
        --viewCount;
        if (viewsFirst == viewsLast) {
            viewsLast = null;
            viewsFirst = null;
            return;
        }
        if (view == viewsFirst) {
            viewsFirst = view.next;
            view.next.prev = null;
        } else {
            view.prev.next = view.next;
        }
        if (view == viewsLast) {
            viewsLast = jEdit.viewsLast.prev;
            view.prev.next = null;
        } else {
            view.next.prev = view.prev;
        }
    }

    private static boolean closeView(View view, boolean bl) {
        PerspectiveManager.setPerspectiveDirty(true);
        if (viewsFirst == viewsLast && bl) {
            jEdit.exit(view, false);
            return false;
        }
        if (!view.confirmToCloseDirty()) {
            return false;
        }
        view.close();
        view.dispose();
        jEdit.removeViewFromList(view);
        if (view == activeView) {
            activeView = null;
        }
        return true;
    }

    private static void loadModeCatalog(String string, boolean bl) {
        Log.log(3, jEdit.class, "Loading mode catalog file " + string);
        ModeCatalogHandler modeCatalogHandler = new ModeCatalogHandler(MiscUtilities.getParentOfPath(string), bl){

            @Override
            protected Mode instantiateMode(String string) {
                return new JEditMode(string);
            }
        };
        try {
            InputStream inputStream = bl ? jEdit.class.getResourceAsStream(string) : new FileInputStream(string);
            XMLUtilities.parseXML(inputStream, modeCatalogHandler);
        }
        catch (IOException iOException) {
            Log.log(9, jEdit.class, iOException);
        }
    }

    private static void initKeyBindings() {
        inputHandler.removeAllKeyBindings();
        ActionSet[] actionSetArray = jEdit.getActionSets();
        for (int i = 0; i < actionSetArray.length; ++i) {
            actionSetArray[i].initKeyBindings();
        }
    }

    private static void composeBufferPropsFromHistory(Map<String, Object> map, String string) {
        BufferHistory.Entry entry = BufferHistory.getEntry(string);
        if (entry != null && saveCaret && map.get("Buffer__caret") == null) {
            map.put("Buffer__caret", entry.caret);
            if (entry.selection != null) {
                map.put("Buffer__selection", entry.getSelection());
            }
        }
        if (entry != null && map.get("encoding") == null && entry.encoding != null) {
            map.put("encoding", entry.encoding);
        }
        if (entry != null && map.get("mode") == null && entry.mode != null) {
            map.put("mode", entry.mode);
        }
    }

    static {
        pluginErrorLock = new Object();
        propertyManager = new JEditPropertyManager();
        startupTime = System.currentTimeMillis();
        bufferListLock = new Object();
        editBusOrderingLock = new Object();
        startupDone = new Vector<Boolean>();
        additionalFiles = new Vector();
    }

    private static class DockingLayoutSetter
    implements Runnable {
        private final View view;
        private final View.ViewConfig config;
        private final int startupDoneIndex;

        DockingLayoutSetter(View view, View.ViewConfig viewConfig, int n) {
            this.view = view;
            this.config = viewConfig;
            this.startupDoneIndex = n;
        }

        @Override
        public void run() {
            DockableWindowManager dockableWindowManager = this.view.getDockableWindowManager();
            dockableWindowManager.setDockingLayout(this.config.docking);
            startupDone.set(this.startupDoneIndex, true);
        }
    }

    public static class JEditPropertyManager
    implements IPropertyManager {
        @Override
        public String getProperty(String string) {
            return jEdit.getProperty(string);
        }
    }

    private static class MyFocusManager
    extends DefaultKeyboardFocusManager {
        MyFocusManager() {
            this.setDefaultFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                Component component = (Component)keyEvent.getSource();
                if (!component.isShowing()) {
                    return true;
                }
                while (true) {
                    if (component instanceof View) {
                        ((View)component).getInputHandler().processKeyEvent(keyEvent, 0, false);
                        return true;
                    }
                    if (component == null || component instanceof Window || component instanceof JEditTextArea) {
                        if (!(component instanceof PluginManager)) break;
                        keyEvent.setSource(component);
                        ((PluginManager)component).processKeyEvents(keyEvent);
                        break;
                    }
                    component = component.getParent();
                }
            }
            return super.postProcessKeyEvent(keyEvent);
        }
    }

    static class FirewallAuthenticator
    extends Authenticator {
        PasswordAuthentication pw;

        FirewallAuthenticator(PasswordAuthentication passwordAuthentication) {
            this.pw = passwordAuthentication;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this.pw;
        }
    }
}

