/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.browser.VFSFileChooserDialog;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.pluginmgr.KeyboardCommand;
import org.gjt.sp.jedit.pluginmgr.PluginDetailPanel;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ManagePanel
extends JPanel {
    private final JCheckBox hideLibraries;
    private final JTable table;
    private final JScrollPane scrollpane;
    private final PluginDetailPanel pluginDetailPanel;
    private final PluginTableModel pluginModel;
    private final PluginManager window;
    private JPopupMenu popup;
    private Set<String> selectedPlugins;
    private Set<String> jarNames;

    public ManagePanel(PluginManager pluginManager) {
        super(new BorderLayout(12, 12));
        this.window = pluginManager;
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Box box = new Box(0);
        this.hideLibraries = new HideLibrariesButton();
        box.add(this.hideLibraries);
        this.add("North", box);
        this.pluginModel = new PluginTableModel();
        this.table = new JTable(this.pluginModel);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowHeight(this.table.getRowHeight() + 2);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 300));
        this.table.setDefaultRenderer(Object.class, new TextRenderer((DefaultTableCellRenderer)this.table.getDefaultRenderer(Object.class)));
        this.table.addFocusListener(new TableFocusHandler());
        this.table.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        InputMap inputMap = this.table.getInputMap(0);
        ActionMap actionMap = this.table.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "tabOutForward");
        actionMap.put("tabOutForward", new KeyboardAction(KeyboardCommand.TAB_OUT_FORWARD));
        inputMap.put(KeyStroke.getKeyStroke(9, 1), "tabOutBack");
        actionMap.put("tabOutBack", new KeyboardAction(KeyboardCommand.TAB_OUT_BACK));
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "editPlugin");
        actionMap.put("editPlugin", new KeyboardAction(KeyboardCommand.EDIT_PLUGIN));
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "closePluginManager");
        actionMap.put("closePluginManager", new KeyboardAction(KeyboardCommand.CLOSE_PLUGIN_MANAGER));
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        TableColumn tableColumn3 = this.table.getColumnModel().getColumn(2);
        TableColumn tableColumn4 = this.table.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(30);
        tableColumn.setMinWidth(30);
        tableColumn.setMaxWidth(30);
        tableColumn.setResizable(false);
        tableColumn2.setPreferredWidth(300);
        tableColumn3.setPreferredWidth(100);
        tableColumn4.setPreferredWidth(100);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        HeaderMouseHandler headerMouseHandler = new HeaderMouseHandler();
        jTableHeader.addMouseListener(headerMouseHandler);
        this.table.addMouseListener(headerMouseHandler);
        this.scrollpane = new JScrollPane(this.table);
        this.scrollpane.getViewport().setBackground(this.table.getBackground());
        this.pluginDetailPanel = new PluginDetailPanel();
        this.scrollpane.setPreferredSize(new Dimension(400, 400));
        JSplitPane jSplitPane = new JSplitPane(0, true, this.scrollpane, this.pluginDetailPanel);
        this.add("Center", jSplitPane);
        jSplitPane.setResizeWeight(0.75);
        Box box2 = new Box(0);
        box2.add(new RemoveButton());
        box2.add(new SaveButton());
        box2.add(new RestoreButton());
        box2.add(new FindOrphan());
        box2.add(Box.createGlue());
        box2.add(new HelpButton());
        this.add("South", box2);
        this.pluginModel.update();
    }

    public void update() {
        this.pluginModel.update();
    }

    boolean loadPluginSet(String string) {
        VFS vFS = VFSManager.getVFSForPath(string);
        Object object = vFS.createVFSSession(string, this);
        try {
            InputStream inputStream = vFS._createInputStream(object, string, false, this);
            XMLUtilities.parseXML(inputStream, new ManagePanelRestoreHandler());
            inputStream.close();
            int n = this.pluginModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                Entry entry = this.pluginModel.getEntry(i);
                String string2 = entry.name;
                if (string2 != null) {
                    this.pluginModel.setValueAt(this.selectedPlugins.contains(string2), i, 0);
                    continue;
                }
                String string3 = entry.jar;
                String string4 = string3.substring(1 + string3.lastIndexOf(File.separatorChar));
                try {
                    this.pluginModel.setValueAt(this.jarNames.contains(string4), i, 0);
                    continue;
                }
                catch (Exception exception) {
                    Log.log(7, this, "Exception thrown loading: " + string4, exception);
                }
            }
        }
        catch (Exception exception) {
            Log.log(9, this, "Loading Pluginset Error", exception);
            return false;
        }
        this.pluginModel.update();
        return true;
    }

    private static Collection<String> getDeclaredJars(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        PluginJAR pluginJAR = new PluginJAR(new File(string));
        PluginJAR.PluginCacheEntry pluginCacheEntry = PluginJAR.getPluginCache(pluginJAR);
        if (pluginCacheEntry == null) {
            pluginCacheEntry = pluginJAR.generateCache();
        }
        if (pluginCacheEntry == null) {
            Log.log(7, ManagePanel.class, "couldn't load plugin " + pluginJAR.getPath() + " (most likely other version exists)");
        } else {
            Properties properties = pluginCacheEntry.cachedProperties;
            String string2 = properties.getProperty("plugin." + pluginCacheEntry.pluginClass + ".jars");
            if (string2 != null) {
                String string3 = MiscUtilities.getParentOfPath(pluginJAR.getPath());
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = MiscUtilities.constructPath(string3, stringTokenizer.nextToken());
                    if (!new File(string4).exists()) continue;
                    arrayList.add(string4);
                }
            }
        }
        arrayList.add(string);
        return arrayList;
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = ManagePanel.this.table.getSelectedRow();
            if (n != -1) {
                Entry entry = ManagePanel.this.pluginModel.getEntry(n);
                ManagePanel.this.pluginDetailPanel.setPlugin(entry);
            }
        }
    }

    private class TableFocusHandler
    extends FocusAdapter {
        private TableFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (ManagePanel.this.table.getSelectedRow() == -1) {
                ManagePanel.this.table.setRowSelectionInterval(0, 0);
                JScrollBar jScrollBar = ManagePanel.this.scrollpane.getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getMinimum());
            }
            if (ManagePanel.this.table.getSelectedColumn() == -1) {
                ManagePanel.this.table.setColumnSelectionInterval(0, 0);
            }
        }
    }

    private class KeyboardAction
    extends AbstractAction {
        private KeyboardCommand command = KeyboardCommand.NONE;

        KeyboardAction(KeyboardCommand keyboardCommand) {
            this.command = keyboardCommand;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.command) {
                case TAB_OUT_FORWARD: {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    break;
                }
                case TAB_OUT_BACK: {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                    break;
                }
                case EDIT_PLUGIN: {
                    int[] nArray = ManagePanel.this.table.getSelectedRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        Object object = ManagePanel.this.pluginModel.getValueAt(nArray[i], 0);
                        ManagePanel.this.pluginModel.setValueAt(object.equals(Boolean.FALSE), nArray[i], 0);
                    }
                    break;
                }
                case CLOSE_PLUGIN_MANAGER: {
                    ManagePanel.this.window.ok();
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
    }

    private class HeaderMouseHandler
    extends MouseAdapter {
        private HeaderMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == ManagePanel.this.table.getTableHeader()) {
                switch (ManagePanel.this.table.getTableHeader().columnAtPoint(mouseEvent.getPoint())) {
                    case 1: {
                        ManagePanel.this.pluginModel.setSortType(1);
                        break;
                    }
                    case 3: {
                        ManagePanel.this.pluginModel.setSortType(2);
                        break;
                    }
                }
            } else if (GUIUtilities.isPopupTrigger(mouseEvent)) {
                int n = ManagePanel.this.table.rowAtPoint(mouseEvent.getPoint());
                if (n != -1 && !ManagePanel.this.table.isRowSelected(n)) {
                    ManagePanel.this.table.setRowSelectionInterval(n, n);
                }
                if (ManagePanel.this.popup == null) {
                    ManagePanel.this.popup = new JPopupMenu();
                    JMenuItem jMenuItem = GUIUtilities.loadMenuItem("plugin-manager.cleanup");
                    jMenuItem.addActionListener(new CleanupActionListener());
                    ManagePanel.this.popup.add(jMenuItem);
                }
                GUIUtilities.showPopupMenu(ManagePanel.this.popup, ManagePanel.this.table, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private class CleanupActionListener
        implements ActionListener {
            private CleanupActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ManagePanel.this.table.getSelectedRows();
                ArrayList<String> arrayList = new ArrayList<String>(nArray.length);
                ArrayList<Entry> arrayList2 = new ArrayList<Entry>(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    Entry entry = ManagePanel.this.pluginModel.getEntry(nArray[i]);
                    if (entry.plugin == null) continue;
                    arrayList.add(entry.name);
                    arrayList2.add(entry);
                }
                Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
                int n = GUIUtilities.listConfirm(ManagePanel.this, "plugin-manager.cleanup", null, objectArray);
                if (n != 0) {
                    return;
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    Entry entry = (Entry)arrayList2.get(i);
                    File file = entry.plugin.getPluginHome();
                    Log.log(5, this, "Removing data of plugin " + entry.name + " home=" + file);
                    FileVFS.recursiveDelete(file);
                    entry.dataSize = null;
                }
                ManagePanel.this.table.repaint();
            }
        }
    }

    private static class EntryCompare
    implements Comparator<Entry> {
        public static final int NAME = 1;
        public static final int STATUS = 2;
        private final int type;

        EntryCompare(int n) {
            this.type = n;
        }

        @Override
        public int compare(Entry entry, Entry entry2) {
            if (this.type == 1) {
                return EntryCompare.compareNames(entry, entry2);
            }
            int n = entry.status.compareToIgnoreCase(entry2.status);
            if (n == 0) {
                return EntryCompare.compareNames(entry, entry2);
            }
            return n;
        }

        private static int compareNames(Entry entry, Entry entry2) {
            String string = entry.name == null ? MiscUtilities.getFileName(entry.jar) : entry.name;
            String string2 = entry2.name == null ? MiscUtilities.getFileName(entry2.jar) : entry2.name;
            return string.compareToIgnoreCase(string2);
        }
    }

    private class HelpButton
    extends JButton
    implements ListSelectionListener,
    ActionListener {
        private URL docURL;

        HelpButton() {
            super(jEdit.getProperty("manage-plugins.help"));
            ManagePanel.this.table.getSelectionModel().addListSelectionListener(this);
            this.addActionListener(this);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new HelpViewer(this.docURL);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ManagePanel.this.table.getSelectedRowCount() == 1) {
                try {
                    Entry entry = ManagePanel.this.pluginModel.getEntry(ManagePanel.this.table.getSelectedRow());
                    String string = entry.clazz;
                    String string2 = entry.docs;
                    if (string != null) {
                        URL uRL;
                        EditPlugin editPlugin = jEdit.getPlugin(string, false);
                        PluginJAR pluginJAR = null;
                        if (editPlugin != null) {
                            pluginJAR = editPlugin.getPluginJAR();
                        }
                        if (pluginJAR != null && string2 != null && (uRL = pluginJAR.getClassLoader().getResource(string2)) != null) {
                            this.docURL = uRL;
                            this.setEnabled(true);
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    Log.log(9, this, "ManagePanel HelpButton Update", exception);
                }
            }
            this.setEnabled(false);
        }
    }

    private class FindOrphan
    extends JButton
    implements ActionListener {
        private FindOrphan() {
            super(jEdit.getProperty("plugin-manager.findOrphan.label"));
            this.addActionListener(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            Object object32;
            PluginJAR[] pluginJARArray = jEdit.getPluginJARs();
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (PluginJAR object42 : pluginJARArray) {
                object32 = object42.getPlugin();
                if (object32 == null) {
                    hashMap.put(new File(object42.getPath()).getName(), object42.getPath());
                    continue;
                }
                object2 = ((EditPlugin)object32).getPluginJAR().getRequiredJars();
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = object.next();
                    hashSet.add(new File(string).getName());
                }
            }
            Object[] objectArray = jEdit.getNotLoadedPluginJARs();
            for (int i = 0; i < objectArray.length; ++i) {
                PluginJAR pluginJAR = new PluginJAR(new File((String)objectArray[i]));
                PluginJAR.PluginCacheEntry pluginCacheEntry = PluginJAR.getPluginCache(pluginJAR);
                try {
                    void var8_15;
                    if (pluginCacheEntry == null) {
                        PluginJAR.PluginCacheEntry pluginCacheEntry2 = pluginJAR.generateCache();
                    }
                    if (var8_15 == null) {
                        Log.log(7, ManagePanel.class, "couldn't load plugin " + pluginJAR.getPath() + " (most likely other version exists)");
                    }
                    if (var8_15 == null || var8_15.pluginClass == null) {
                        hashMap.put(new File((String)objectArray[i]).getName(), objectArray[i]);
                        continue;
                    }
                    object32 = var8_15.cachedProperties;
                    object2 = ((Properties)object32).getProperty("plugin." + var8_15.pluginClass + ".jars");
                    if (object2 == null) continue;
                    object = new StringTokenizer((String)object2);
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        hashSet.add(((StringTokenizer)object).nextToken());
                    }
                    continue;
                }
                catch (IOException iOException) {
                    Log.log(9, this, actionEvent);
                }
            }
            ArrayList arrayList = new ArrayList();
            Set set = hashMap.keySet();
            for (Object object32 : set) {
                if (hashSet.contains(object32)) continue;
                arrayList.add(object32);
                Log.log(3, this, "It seems that this jar do not belong to any plugin " + object32);
            }
            if (arrayList.isEmpty()) {
                GUIUtilities.message(ManagePanel.this, "plugin-manager.noOrphan", null);
                return;
            }
            Object[] objectArray2 = arrayList.toArray(new String[arrayList.size()]);
            int n = GUIUtilities.listConfirm(ManagePanel.this, "plugin-manager.findOrphan", null, objectArray2, object32 = new ArrayList());
            if (n != 0 || object32.isEmpty()) {
                return;
            }
            object = new Roster();
            for (int i = 0; i < object32.size(); ++i) {
                String string = (String)object32.get(i);
                ((Roster)object).addRemove((String)hashMap.get(string));
            }
            ((Roster)object).performOperationsInAWTThread(ManagePanel.this.window);
            ManagePanel.this.pluginModel.update();
            if (ManagePanel.this.table.getRowCount() != 0) {
                ManagePanel.this.table.setRowSelectionInterval(0, 0);
            }
            ManagePanel.this.table.setColumnSelectionInterval(0, 0);
            JScrollBar jScrollBar = ManagePanel.this.scrollpane.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMinimum());
            ManagePanel.this.table.repaint();
        }
    }

    private class RemoveButton
    extends JButton
    implements ListSelectionListener,
    ActionListener {
        RemoveButton() {
            super(jEdit.getProperty("manage-plugins.remove"));
            ManagePanel.this.table.getSelectionModel().addListSelectionListener(this);
            this.addActionListener(this);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            int[] nArray = ManagePanel.this.table.getSelectedRows();
            LinkedList<String> linkedList = new LinkedList<String>();
            Roster roster = new Roster();
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            for (int i = 0; i < nArray.length; ++i) {
                Entry arrayList2 = ManagePanel.this.pluginModel.getEntry(nArray[i]);
                if (arrayList2.status.equals("not-loaded") || arrayList2.status.equals("disabled")) {
                    if (arrayList2.jar != null) {
                        try {
                            object = ManagePanel.getDeclaredJars(arrayList2.jar);
                            hashSet.addAll((Collection<String>)object);
                        }
                        catch (IOException iOException) {
                            Log.log(9, this, iOException);
                        }
                    }
                } else {
                    hashSet.addAll(arrayList2.jars);
                    hashSet2.addAll(arrayList2.jars);
                }
                ManagePanel.this.table.getSelectionModel().removeSelectionInterval(nArray[i], nArray[i]);
            }
            for (String string : hashSet) {
                linkedList.add(string);
                roster.addRemove(string);
            }
            int n = GUIUtilities.listConfirm(ManagePanel.this.window, "plugin-manager.remove-confirm", null, linkedList.toArray());
            if (n == 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                PluginJAR.transitiveClosure(hashSet2.toArray(new String[hashSet2.size()]), arrayList);
                arrayList.removeAll(linkedList);
                if (arrayList.isEmpty()) {
                    n = 0;
                } else {
                    n = GUIUtilities.listConfirm(ManagePanel.this.window, "plugin-manager.remove-dependencies", null, arrayList.toArray());
                    Collections.sort(arrayList, new StandardUtilities.StringCompare(true));
                }
                if (n == 0) {
                    for (String string : arrayList) {
                        PluginJAR pluginJAR = jEdit.getPluginJAR(string);
                        jEdit.removePluginJAR(pluginJAR, false);
                    }
                    roster.performOperationsInAWTThread(ManagePanel.this.window);
                    ManagePanel.this.pluginModel.update();
                    if (ManagePanel.this.table.getRowCount() != 0) {
                        ManagePanel.this.table.setRowSelectionInterval(0, 0);
                    }
                    ManagePanel.this.table.setColumnSelectionInterval(0, 0);
                    object = ManagePanel.this.scrollpane.getVerticalScrollBar();
                    ((JScrollBar)object).setValue(((JScrollBar)object).getMinimum());
                }
            }
            PluginManager.getInstance().pluginRemoved();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ManagePanel.this.table.getSelectedRowCount() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class SaveButton
    extends RolloverButton
    implements ActionListener {
        SaveButton() {
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("manage-plugins.save.icon")));
            this.setToolTipText("Save Currently Checked Plugins Set");
            this.addActionListener(this);
            this.setEnabled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void saveState(String string, List<Entry> list) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder("<pluginset>\n ");
            for (Entry object22 : list) {
                object = object22.jar.substring(1 + object22.jar.lastIndexOf(File.separatorChar));
                stringBuilder.append("   <plugin name=\"").append(object22.name).append("\" jar=\"");
                stringBuilder.append((String)object).append("\" />\n ");
            }
            stringBuilder.append("</pluginset>\n");
            VFS vFS = VFSManager.getVFSForPath(string);
            Object object2 = vFS.createVFSSession(string, ManagePanel.this);
            object = null;
            try {
                OutputStream exception = vFS._createOutputStream(object2, string, ManagePanel.this);
                object = new BufferedWriter(new OutputStreamWriter(exception, "utf-8"));
                ((Writer)object).write(stringBuilder.toString());
            }
            catch (Exception exception) {
                Log.log(9, this, "Saving State Error", exception);
            }
            finally {
                IOUtilities.closeQuietly((Closeable)object);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PluginJAR[] pluginJARArray;
            String string = jEdit.getProperty("plugin-manager.pluginset.path", jEdit.getSettingsDirectory() + File.separator);
            VFSFileChooserDialog vFSFileChooserDialog = new VFSFileChooserDialog(ManagePanel.this.window, jEdit.getActiveView(), string, 1, false, true);
            String[] stringArray = vFSFileChooserDialog.getSelectedFiles();
            ArrayList<Entry> arrayList = new ArrayList<Entry>();
            if (stringArray == null || stringArray.length != 1) {
                return;
            }
            for (PluginJAR pluginJAR : pluginJARArray = jEdit.getPluginJARs()) {
                if (pluginJAR.getPlugin() == null) continue;
                Entry entry = new Entry(pluginJAR);
                arrayList.add(entry);
            }
            this.saveState(stringArray[0], arrayList);
            jEdit.setProperty("plugin-manager.pluginset.path", stringArray[0]);
            EditBus.send(new PropertiesChanged(PluginManager.getInstance()));
        }
    }

    private class RestoreButton
    extends RolloverButton
    implements ActionListener {
        RestoreButton() {
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("manage-plugins.restore.icon")));
            this.addActionListener(this);
            this.setToolTipText("Choose a PluginSet, select/deselect plugins based on set.");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = jEdit.getProperty("plugin-manager.pluginset.path", jEdit.getSettingsDirectory() + File.separator);
            String[] stringArray = GUIUtilities.showVFSFileDialog(ManagePanel.this.window, jEdit.getActiveView(), string, 0, false);
            if (stringArray == null || stringArray.length != 1) {
                return;
            }
            string = stringArray[0];
            boolean bl = ManagePanel.this.loadPluginSet(string);
            if (bl) {
                jEdit.setProperty("plugin-manager.pluginset.path", string);
                EditBus.send(new PropertiesChanged(PluginManager.getInstance()));
            }
        }
    }

    private class HideLibrariesButton
    extends JCheckBox
    implements ActionListener {
        HideLibrariesButton() {
            super(jEdit.getProperty("plugin-manager.hide-libraries"));
            this.setSelected(jEdit.getBooleanProperty("plugin-manager.hide-libraries.toggle"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            jEdit.setBooleanProperty("plugin-manager.hide-libraries.toggle", this.isSelected());
            ManagePanel.this.update();
        }
    }

    private class TextRenderer
    extends DefaultTableCellRenderer {
        private final DefaultTableCellRenderer tcr;

        TextRenderer(DefaultTableCellRenderer defaultTableCellRenderer) {
            this.tcr = defaultTableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Entry entry = ManagePanel.this.pluginModel.getEntry(n);
            if (entry.status.equals("error") || entry.status.equals("disabled")) {
                this.tcr.setForeground(Color.red);
            } else {
                this.tcr.setForeground(UIManager.getColor("Table.foreground"));
            }
            return this.tcr.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }
    }

    private class PluginTableModel
    extends AbstractTableModel {
        private final List<Entry> entries = new ArrayList<Entry>();
        private int sortType = 1;
        private ConcurrentHashMap<String, Object> unloaded;

        PluginTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return jEdit.getProperty("manage-plugins.info.name");
                }
                case 2: {
                    return jEdit.getProperty("manage-plugins.info.version");
                }
                case 3: {
                    return jEdit.getProperty("manage-plugins.info.status");
                }
                case 4: {
                    return jEdit.getProperty("manage-plugins.info.data");
                }
            }
            throw new Error("Column out of range");
        }

        public Entry getEntry(int n) {
            return this.entries.get(n);
        }

        @Override
        public int getRowCount() {
            return this.entries.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Entry entry = this.entries.get(n);
            switch (n2) {
                case 0: {
                    return !entry.status.equals("not-loaded") && !entry.status.equals("disabled");
                }
                case 1: {
                    if (entry.name == null) {
                        return MiscUtilities.getFileName(entry.jar);
                    }
                    return entry.name;
                }
                case 2: {
                    return entry.version;
                }
                case 3: {
                    return jEdit.getProperty("plugin-manager.status." + entry.status);
                }
                case 4: {
                    if (entry.dataSize == null && entry.plugin != null) {
                        File file = entry.plugin.getPluginHome();
                        if (null == file) {
                            return null;
                        }
                        entry.dataSize = file.exists() ? StandardUtilities.formatFileSize(IOUtilities.fileLength(file)) : (jEdit.getBooleanProperty("plugin." + entry.clazz + ".usePluginHome") ? StandardUtilities.formatFileSize(0L) : jEdit.getProperty("manage-plugins.data-size.unknown"));
                    }
                    return entry.dataSize;
                }
            }
            throw new Error("Column out of range");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Entry entry = this.entries.get(n);
            if (n2 == 0) {
                PluginJAR pluginJAR = jEdit.getPluginJAR(entry.jar);
                if (pluginJAR == null) {
                    if (object.equals(Boolean.FALSE)) {
                        return;
                    }
                    PluginJAR pluginJAR2 = PluginJAR.load(entry.jar, true);
                    if (pluginJAR2 == null) {
                        GUIUtilities.error(ManagePanel.this, "plugin-load-error", null);
                    }
                } else {
                    if (object.equals(Boolean.TRUE)) {
                        return;
                    }
                    this.unloadPluginJARWithDialog(pluginJAR);
                }
            }
            this.update();
        }

        public void setSortType(int n) {
            this.sortType = n;
            this.sort(n);
        }

        public void sort(int n) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.saveSelection(arrayList);
            Collections.sort(this.entries, new EntryCompare(n));
            this.fireTableChanged(new TableModelEvent(this));
            this.restoreSelection(arrayList);
        }

        public void update() {
            Entry entry;
            ArrayList<String> arrayList = new ArrayList<String>();
            this.saveSelection(arrayList);
            this.entries.clear();
            String string = MiscUtilities.constructPath(jEdit.getJEditHome(), "jars");
            String string2 = jEdit.getSettingsDirectory();
            String string3 = string2 == null ? null : MiscUtilities.constructPath(string2, "jars");
            PluginJAR[] pluginJARArray = jEdit.getPluginJARs();
            for (int i = 0; i < pluginJARArray.length; ++i) {
                String string4 = pluginJARArray[i].getPath();
                if (!string4.startsWith(string) && (string3 == null || !string4.startsWith(string3))) continue;
                entry = new Entry(pluginJARArray[i]);
                if (ManagePanel.this.hideLibraries.isSelected() && entry.clazz == null) continue;
                this.entries.add(entry);
            }
            String[] stringArray = jEdit.getNotLoadedPluginJARs();
            for (int i = 0; i < stringArray.length; ++i) {
                entry = new Entry(stringArray[i]);
                this.entries.add(entry);
            }
            this.sort(this.sortType);
            this.restoreSelection(arrayList);
        }

        private void unloadPluginJARWithDialog(PluginJAR pluginJAR) {
            this.unloaded = new ConcurrentHashMap();
            String[] stringArray = pluginJAR.getDependentPlugins();
            if (stringArray.length == 0) {
                this.unloadPluginJAR(pluginJAR);
            } else {
                LinkedList<String> linkedList = new LinkedList<String>();
                PluginJAR.transitiveClosure(stringArray, linkedList);
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(linkedList);
                Collections.sort(arrayList, new StandardUtilities.StringCompare(true));
                int n = GUIUtilities.listConfirm(ManagePanel.this.window, "plugin-manager.dependency", new String[]{pluginJAR.getFile().getName()}, arrayList.toArray());
                if (n == 0) {
                    this.unloadPluginJAR(pluginJAR);
                }
            }
        }

        private void unloadPluginJAR(PluginJAR pluginJAR) {
            String[] stringArray;
            for (String string : stringArray = pluginJAR.getDependentPlugins()) {
                if (this.unloaded.containsKey(string)) continue;
                this.unloaded.put(string, Boolean.TRUE);
                PluginJAR pluginJAR2 = jEdit.getPluginJAR(string);
                if (pluginJAR2 == null) continue;
                this.unloadPluginJAR(pluginJAR2);
            }
            jEdit.removePluginJAR(pluginJAR, false);
            jEdit.setBooleanProperty("plugin-blacklist." + MiscUtilities.getFileName(pluginJAR.getPath()), true);
            jEdit.propertiesChanged();
        }

        public void saveSelection(List<String> list) {
            if (ManagePanel.this.table != null) {
                int[] nArray = ManagePanel.this.table.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    list.add(this.entries.get((int)nArray[i]).jar);
                }
            }
        }

        public void restoreSelection(List<String> list) {
            if (null != ManagePanel.this.table) {
                ManagePanel.this.table.setColumnSelectionInterval(0, 0);
                if (!list.isEmpty()) {
                    int n;
                    int n2 = this.getRowCount();
                    for (n = 0; n < n2; ++n) {
                        if (!list.contains(this.entries.get((int)n).jar)) continue;
                        ManagePanel.this.table.setRowSelectionInterval(n, n);
                        break;
                    }
                    ListSelectionModel listSelectionModel = ManagePanel.this.table.getSelectionModel();
                    while (n < n2) {
                        if (list.contains(this.entries.get((int)n).jar)) {
                            listSelectionModel.addSelectionInterval(n, n);
                        }
                        ++n;
                    }
                } else {
                    if (ManagePanel.this.table.getRowCount() != 0) {
                        ManagePanel.this.table.setRowSelectionInterval(0, 0);
                    }
                    JScrollBar jScrollBar = ManagePanel.this.scrollpane.getVerticalScrollBar();
                    jScrollBar.setValue(jScrollBar.getMinimum());
                }
            }
        }
    }

    static class Entry {
        static final String LOADED = "loaded";
        static final String NOT_LOADED = "not-loaded";
        static final String ERROR = "error";
        static final String DISABLED = "disabled";
        final String status;
        final String jar;
        String clazz;
        String name;
        String version;
        String author;
        String docs;
        String description;
        EditPlugin plugin;
        final List<String> jars = new LinkedList<String>();
        String dataSize;

        Entry(String string) {
            this.jar = string;
            this.jars.add(this.jar);
            this.status = jEdit.getBooleanProperty("plugin." + MiscUtilities.getFileName(string) + ".disabled") ? DISABLED : NOT_LOADED;
        }

        Entry(PluginJAR pluginJAR) {
            this.jar = pluginJAR.getPath();
            this.jars.add(this.jar);
            this.plugin = pluginJAR.getPlugin();
            if (this.plugin != null) {
                Object object;
                String string;
                this.status = this.plugin instanceof EditPlugin.Broken ? ERROR : LOADED;
                this.clazz = this.plugin.getClassName();
                this.name = jEdit.getProperty("plugin." + this.clazz + ".name");
                this.version = jEdit.getProperty("plugin." + this.clazz + ".version");
                this.author = jEdit.getProperty("plugin." + this.clazz + ".author");
                this.docs = jEdit.getProperty("plugin." + this.clazz + ".docs");
                this.description = jEdit.getProperty("plugin." + this.clazz + ".description");
                String string2 = jEdit.getProperty("plugin." + this.clazz + ".jars");
                if (string2 != null) {
                    string = MiscUtilities.getParentOfPath(this.jar);
                    object = new StringTokenizer(string2);
                    while (((StringTokenizer)object).hasMoreElements()) {
                        this.jars.add(MiscUtilities.constructPath(string, ((StringTokenizer)object).nextToken()));
                    }
                }
                if ((string = jEdit.getProperty("plugin." + this.clazz + ".files")) != null) {
                    object = MiscUtilities.getParentOfPath(this.jar);
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    while (stringTokenizer.hasMoreElements()) {
                        this.jars.add(MiscUtilities.constructPath((String)object, stringTokenizer.nextToken()));
                    }
                }
            } else {
                this.status = LOADED;
            }
        }
    }

    private class ManagePanelRestoreHandler
    extends DefaultHandler {
        ManagePanelRestoreHandler() {
            ManagePanel.this.selectedPlugins = new HashSet();
            ManagePanel.this.jarNames = new HashSet();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string2.equals("plugin")) {
                String string4 = attributes.getValue("jar");
                String string5 = attributes.getValue("name");
                ManagePanel.this.selectedPlugins.add(string5);
                ManagePanel.this.jarNames.add(string4);
            }
        }
    }
}

