/*
 * Decompiled with CFR 0.152.
 */
package buffertabs;

import buffertabs.BufferTabs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.jEdit;

class BufferTabComponent
extends JPanel {
    private static CloseIcon icon = new CloseIcon();
    private static Dimension iconDimension = new Dimension(icon.getIconWidth(), icon.getIconHeight());
    private BufferTabs pane;

    BufferTabComponent(BufferTabs bufferTabs) {
        super(new FlowLayout(1, 5, 0));
        this.pane = bufferTabs;
        this.setOpaque(false);
        BufferTabLabel l = new BufferTabLabel(this);
        this.add(l);
        JLabel close = new JLabel(icon);
        close.setPreferredSize(iconDimension);
        close.setForeground(Color.BLACK);
        this.add(close);
        close.addMouseListener(new BufferTabCloseButtonListener(this));
    }

    private class BufferTabLabel
    extends JLabel {
        private BufferTabComponent component;

        BufferTabLabel(BufferTabComponent component) {
            this.component = component;
        }

        @Override
        public Icon getIcon() {
            int index = BufferTabComponent.this.pane.indexOfTabComponent(this.component);
            if (index < 0) {
                return null;
            }
            return BufferTabComponent.this.pane.getIconAt(index);
        }

        @Override
        public String getText() {
            int index = BufferTabComponent.this.pane.indexOfTabComponent(this.component);
            if (index < 0) {
                return null;
            }
            return BufferTabComponent.this.pane.getTitleAt(index);
        }
    }

    private class BufferTabCloseButtonListener
    extends MouseAdapter {
        private BufferTabComponent component;

        BufferTabCloseButtonListener(BufferTabComponent component) {
            this.component = component;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JLabel close = (JLabel)e.getSource();
            close.setForeground(Color.RED);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JLabel close = (JLabel)e.getSource();
            close.setForeground(Color.BLACK);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index = BufferTabComponent.this.pane.indexOfTabComponent(this.component);
            if (index < 0) {
                return;
            }
            EditPane editPane = BufferTabComponent.this.pane.getEditPane();
            jEdit.closeBuffer((EditPane)editPane, (Buffer)editPane.getBufferSet().getBuffer(index));
        }
    }

    private static class CloseIcon
    implements Icon {
        private static final int width = 9;
        private static final int height = 11;
        private static final int top = 3;

        private CloseIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawLine(0, 3, 7, 10);
            g.drawLine(1, 3, 8, 10);
            g.drawLine(8, 3, 1, 10);
            g.drawLine(7, 3, 0, 10);
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 11;
        }
    }
}

