/*
 * Decompiled with CFR 0.152.
 */
package whitespace;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import whitespace.BlockHighlight;
import whitespace.BufferOptionsOptionPane;
import whitespace.FoldHighlight;
import whitespace.WhiteSpaceHighlight;
import whitespace.WhiteSpaceModel;

public class BufferOptionsDialog
extends EnhancedDialog {
    private OptionPane options;
    private Buffer buffer;
    private View view;
    private JButton ok;
    private JButton cancel;

    public BufferOptionsDialog(Buffer buffer, View view, WhiteSpaceModel model) {
        super((Frame)view, jEdit.getProperty((String)"whitespace.buffer-options-dialog.title"), true);
        this.view = view;
        this.buffer = buffer;
        JPanel content = new JPanel(new BorderLayout());
        this.setContentPane(content);
        this.options = new BufferOptionsOptionPane(model);
        ((JPanel)this.options).setBorder(new EmptyBorder(0, 12, 12, 12));
        this.options.init();
        content.add((Component)((JPanel)this.options), "North");
        JPanel buttons = new JPanel();
        this.ok = new JButton(jEdit.getProperty((String)"common.ok"));
        this.cancel = new JButton(jEdit.getProperty((String)"common.cancel"));
        this.getRootPane().setDefaultButton(this.ok);
        this.ok.addActionListener(new ActionHandler());
        this.cancel.addActionListener(new ActionHandler());
        buttons.add(this.ok);
        buttons.add(this.cancel);
        content.add((Component)buttons, "South");
        this.pack();
        this.setLocationRelativeTo((Component)view);
        this.setVisible(true);
    }

    public void ok() {
        this.options.save();
        WhiteSpaceHighlight.updateTextAreas(this.buffer);
        BlockHighlight.updateTextAreas(this.buffer);
        FoldHighlight.updateTextAreas(this.buffer);
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == BufferOptionsDialog.this.ok) {
                BufferOptionsDialog.this.ok();
            } else if (source == BufferOptionsDialog.this.cancel) {
                BufferOptionsDialog.this.cancel();
            }
        }
    }
}

